/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseStatisticsServer;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.SAPControlWsdlUrl;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.sapcontrol.ArrayOfString;
import com.sap.hdb.sl.lib.sapcontrol.SAPControlPortType;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.OperatingSystemUser;
import com.sap.hdb.sl.lib.user.OperatingSystemUserFactory;
import com.sap.hdb.sl.lib.user.name.OperatingSystemUserName;
import com.sap.hdb.sl.lib.user.password.DatabaseSystemUserPassword;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import com.sap.hdb.sl.lib.utils.SAPControlHelper;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.concurrent.TimeoutException;
import javax.xml.ws.Holder;

public class ExecuteInitTopology
implements CmdClazz {
    private static final long SHUTDOWN_TIMEOUT = 1800000L;
    private static final long STARTUP_TIMEOUT = 3600000L;
    private OperatingSystemUser operatingSystemUser = null;
    private SAPControlWsdlUrl wsdlUrl = null;
    private ResultFileWriter resultWriter = null;
    private DatabaseSystemUserPassword originalDatabaseSystemUserPassword = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private Database database = null;
    private SAPControlHelper helper = new SAPControlHelper();

    protected ExecuteInitTopology() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.operatingSystemUser = OperatingSystemUserFactory.getUser(new OperatingSystemUserName(parameters.get(CmdClazzParameterName.SIDADM_ID).getValue()), PasswordFactory.getOperatingSystemUserPassword(parameters.get(CmdClazzParameterName.SIDADM_PASSWORD).getValue()));
        this.wsdlUrl = new SAPControlWsdlUrl(parameters);
        this.originalDatabaseSystemUserPassword = new DatabaseSystemUserPassword(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.database = InstanceFactory.getDatabaseInstance(parameters);
    }

    @Override
    public void execute() {
        LogFactory.writeLogEntry(this.getClass(), "Creating SAPControl web service client.");
        SAPControlPortType port = this.helper.getPort(this.wsdlUrl.getURL(), this.operatingSystemUser.getName().get(), this.operatingSystemUser.getPassword().get());
        boolean onWindows = this.helper.onWindows(port);
        LogFactory.writeLogEntry(this.getClass(), "Getting HANA system environment.");
        String instanceDir = this.helper.getInstanceDirectory(port);
        if (instanceDir == null) {
            String message = "Unable to determine the value of environment variable DIR_INSTANCE. Please set the variable on the HANA database host and retry.";
            LogFactory.writeLogEntry(this.getClass(), message);
            this.resultWriter.append(String.valueOf(false));
            this.resultWriter.append(Status.DIR_INSTANCE_NOT_FOUND.toString());
            this.resultWriter.append(message);
            return;
        }
        LogFactory.writeLogEntry(this.getClass(), "Stopping HANA instance at " + this.wsdlUrl.getURL().getHost() + ":" + this.wsdlUrl.getURL().getPort());
        try {
            this.helper.stopSystem(port, 1800000L);
        }
        catch (TimeoutException e) {
            LogFactory.writeLogEntry(this.getClass(), e.getMessage());
            this.resultWriter.append(String.valueOf(false));
            this.resultWriter.append(Status.TIMEOUT_SHUTDOWN.toString());
            this.resultWriter.append(e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            String message = "The current thread was interrpted while waiting for the database to shut down.";
            LogFactory.writeLogEntry(this.getClass(), message);
            this.resultWriter.append(String.valueOf(false));
            this.resultWriter.append(Status.TIMEOUT_SHUTDOWN.toString());
            this.resultWriter.append(message);
            return;
        }
        LogFactory.writeLogEntry(this.getClass(), "Executing 'hdbnsutil -initTopology' at " + this.wsdlUrl.getURL().getHost() + ":" + this.wsdlUrl.getURL().getPort());
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String command = onWindows ? instanceDir + "\\exe\\hdbnsutil.exe -initTopology" : instanceDir + "/exe/hdbnsutil -initTopology";
        port.osExecute(command, 0, 0, "initTopology.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "hdbnsutil failed (rc = " + exitcode.value + ").");
            this.resultWriter.append(String.valueOf(false));
            this.resultWriter.append(Status.INIT_TOPOLOGY_ERROR.toString());
            this.resultWriter.append("Error triggering initTopology (RC=" + exitcode.value + ").");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                this.resultWriter.append(line);
            }
            return;
        }
        LogFactory.writeLogEntry(this.getClass(), "Starting HANA instance at " + this.wsdlUrl.getURL().getHost() + ":" + this.wsdlUrl.getURL().getPort());
        try {
            this.helper.startSystem(port, 3600000L);
        }
        catch (TimeoutException e) {
            LogFactory.writeLogEntry(this.getClass(), e.getMessage());
            this.resultWriter.append(String.valueOf(true));
            this.resultWriter.append(Status.TIMEOUT_STARTUP.toString());
            this.resultWriter.append(e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            String message = "The current thread was interrpted while waiting for the database to start up.";
            LogFactory.writeLogEntry(this.getClass(), message);
            this.resultWriter.append(String.valueOf(true));
            this.resultWriter.append(Status.TIMEOUT_STARTUP.toString());
            this.resultWriter.append(message);
        }
        LogFactory.writeLogEntry(this.getClass(), "Command hdbnsutil -initTopology was successful.");
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        if (!"manager".equals(this.originalDatabaseSystemUserPassword.get())) {
            DatabaseSystemUser initialSystemuser = DatabaseSystemUserFactory.getUser(PasswordFactory.getDatabaseSystemUserPassword("manager"));
            initialSystemuser.alterPassword(this.connection, this.originalDatabaseSystemUserPassword);
            LogFactory.writeLogEntry(this.getClass(), "Password for user System was successfully set.");
        }
        this.resultWriter.append(String.valueOf(true));
        this.resultWriter.append(Status.SUCCESS.toString());
        DatabaseSystemUser systemUser = DatabaseSystemUserFactory.getUser(this.originalDatabaseSystemUserPassword);
        DatabaseStatisticsServer statServer = new DatabaseStatisticsServer();
        statServer.setOn(this.connection, systemUser);
        LogFactory.writeLogEntry(this.getClass(), "Database statistics server was successfully switched on.");
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }

    private static enum Status {
        SUCCESS,
        TIMEOUT_SHUTDOWN,
        TIMEOUT_STARTUP,
        DIR_INSTANCE_NOT_FOUND,
        INIT_TOPOLOGY_ERROR;

    }
}

