/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.DatabaseUserFactory;
import com.sap.hdb.sl.lib.utils.IOUtils;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ExecuteSQL
implements CmdClazz {
    private Database database;
    private JdbcDriver jdbcDriver;
    private DatabaseUser sqlUser;
    private String sql;
    private ResultFileWriter resultFileWriter;

    protected ExecuteSQL() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.sqlUser = DatabaseUserFactory.getUser(parameters);
        this.sql = parameters.get(CmdClazzParameterName.SQL_STMT).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void execute() {
        JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        connection.setConnectUser(this.sqlUser);
        PreparedStatement statement = null;
        int result = 0;
        try {
            LogFactory.writeLogEntry(this.getClass(), "Preparing [\"" + this.sql + "\"]...");
            statement = connection.prepareSQLCommand(this.sql);
            result = statement.executeUpdate();
            LogFactory.writeLogEntry(this.getClass(), "SQL Statement [\"" + this.sql + "\"] successfully executed. " + " (Rows: " + result + ")");
            this.resultFileWriter.append(String.valueOf(true));
            this.resultFileWriter.append(String.valueOf(result));
        }
        catch (HdbException e) {
            LogFactory.writeLogEntry(this.getClass(), "Error execute SQL Statement: \"" + this.sql + "\". " + " (SQL error code: " + connection.getErrorCode() + " [" + e.getMessage() + "])");
            this.resultFileWriter.append(String.valueOf(false));
            this.resultFileWriter.append(String.valueOf(result));
            this.resultFileWriter.append(String.valueOf(connection.getErrorCode()));
            this.resultFileWriter.append(String.valueOf(e.getMessage()));
            IOUtils.closeQuietly(statement);
            connection.closeConnection();
        }
        catch (SQLException e2) {
            LogFactory.writeLogEntry(this.getClass(), "Error execute SQL Statement: \"" + this.sql + "\". " + " (SQL error code: " + connection.getErrorCode() + " [" + e2.getMessage() + "])");
            this.resultFileWriter.append(String.valueOf(false));
            this.resultFileWriter.append(String.valueOf(result));
            this.resultFileWriter.append(String.valueOf(connection.getErrorCode()));
            this.resultFileWriter.append(String.valueOf(e2.getMessage()));
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(statement);
                    connection.closeConnection();
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(statement);
            connection.closeConnection();
        }
        IOUtils.closeQuietly(statement);
        connection.closeConnection();
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

