/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.DatabaseUserFactory;
import com.sap.hdb.sl.lib.utils.IOUtils;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ExecuteSQLGetValue
implements CmdClazz {
    private Database database;
    private JdbcDriver jdbcDriver;
    private DatabaseUser sqlUser;
    private String sql;
    private ResultFileWriter resultFileWriter;

    protected ExecuteSQLGetValue() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.sqlUser = DatabaseUserFactory.getUser(parameters);
        this.sql = parameters.get(CmdClazzParameterName.SQL_STMT).getValue();
    }

    @Override
    public void execute() {
        ResultSet resultSet;
        PreparedStatement statement;
        block7: {
            JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
            connection.setConnectUser(this.sqlUser);
            statement = null;
            resultSet = null;
            try {
                statement = connection.prepareSQLCommand(this.sql);
                LogFactory.writeLogEntry(this.getClass(), "Executing [" + this.sql + "]...");
                resultSet = statement.executeQuery();
                int columnCount = resultSet.getMetaData().getColumnCount();
                if (resultSet.next()) {
                    String val = resultSet.getString(1);
                    this.resultFileWriter.append(String.valueOf(true));
                    this.resultFileWriter.append(String.valueOf(val));
                    if (columnCount > 1) {
                        LogFactory.writeLogEntry(this.getClass(), "More than one column in result set(" + columnCount + "). Returning first value.");
                    }
                    if (resultSet.next()) {
                        LogFactory.writeLogEntry(this.getClass(), "More than one row in result set. Only returning first row.");
                    }
                    break block7;
                }
                LogFactory.writeLogEntry(this.getClass(), "No rows returned.");
                this.resultFileWriter.append(String.valueOf(false));
            }
            catch (SQLException e) {
                try {
                    LogFactory.writeLogEntry(this.getClass(), "Error execute SQL Statement: \"" + this.sql + "\". " + " (SQL error code: " + e.getErrorCode() + " [" + e.getMessage() + "])");
                    throw new HdbException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(resultSet);
                    IOUtils.closeQuietly(statement);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly(resultSet);
        IOUtils.closeQuietly(statement);
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

