/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class FillHanaContentComponentTable
implements CmdClazz {
    public static final String TABLE_NAME = "SNHI_DUP_PREWORK";
    private static final Component[] ERP_COMPONENTS = new Component[]{new Component("CC_PSI", Boolean.FALSE), new Component("EA-APPL"), new Component("EA-DFPS"), new Component("EA-FIN"), new Component("EA-FINSERV"), new Component("EA-GLTRADE"), new Component("EA-HR"), new Component("EA-IPPE"), new Component("EA-PS"), new Component("EA-RETAIL"), new Component("ECC-DIMP"), new Component("ECC-SE"), new Component("ERECRUIT"), new Component("FI-CA"), new Component("FI-CAX"), new Component("FINBASIS"), new Component("FSCM_CCD"), new Component("INSURANCE"), new Component("IS-CWM"), new Component("IS-H"), new Component("IS-M"), new Component("IS-OIL"), new Component("IS-PRA"), new Component("IS-PS-CA"), new Component("IS-UT"), new Component("LSOFE"), new Component("MDG_APPL"), new Component("MDG_FND"), new Component("PLMWUI"), new Component("SAP_AP"), new Component("SAP_APPL"), new Component("SAP_BS_FND"), new Component("SAP_FIN"), new Component("SAP_HR"), new Component("SEM-BW"), new Component("WEBCUIF")};
    private static final Component[] CRM_COMPONENTS = new Component[]{new Component("MDG_FND"), new Component("SAP_AP"), new Component("BBPCRM"), new Component("WEBCUIF"), new Component("SAP_BS_FND")};
    private static final Component[] SCM_COMPONENTS = new Component[]{new Component("MDG_FND"), new Component("SAP_AP"), new Component("SAP_BS_FND"), new Component("SAP-SCMOPT"), new Component("SCEMSRV"), new Component("SCM"), new Component("SCM_BASIS"), new Component("SCMBPLUS"), new Component("SCMEWM"), new Component("SCMSNC"), new Component("WEBCUIF")};
    private static final Component[] S4HANA_COMPONENTS = new Component[]{new Component("S4CORE")};
    private static Set<Component> COMPONENTS = FillHanaContentComponentTable.buildSet();
    private Database database;
    private JdbcDriver jdbcDriver;
    private DatabaseSqlUser sqlUser;

    private static Set<Component> buildSet() {
        HashSet set = new HashSet();
        Collections.addAll(set, ERP_COMPONENTS);
        Collections.addAll(set, CRM_COMPONENTS);
        Collections.addAll(set, SCM_COMPONENTS);
        Collections.addAll(set, S4HANA_COMPONENTS);
        return Collections.unmodifiableSet(set);
    }

    protected FillHanaContentComponentTable() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
    }

    @Override
    public void execute() {
        JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        connection.setConnectUser(this.sqlUser);
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareSQLCommand("SELECT count(*) FROM \"PUBLIC\".\"TABLES\" WHERE SCHEMA_NAME=? AND TABLE_NAME=?");
            statement.setString(1, this.sqlUser.getName().get());
            statement.setString(2, TABLE_NAME);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int count = resultSet.getInt(1);
                if (count == 0) {
                    LogFactory.writeLogEntry(this.getClass(), "Table " + this.sqlUser.getName().get() + "." + TABLE_NAME + " doesn't exist.");
                    return;
                }
            } else {
                LogFactory.writeLogEntry(this.getClass(), "Unable to determine whether table " + this.sqlUser.getName().get() + "." + TABLE_NAME + " exists.");
            }
        }
        catch (SQLException e) {
            LogFactory.writeLogEntry(this.getClass(), "Error determining whether table " + this.sqlUser.getName().get() + "." + TABLE_NAME + " exists: " + e.getMessage() + "(SQL error code: " + e.getErrorCode() + ")");
            throw new HdbException(e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
        try {
            statement = connection.prepareSQLCommand("UPSERT \"SNHI_DUP_PREWORK\" VALUES(?,?) WHERE \"SOFTWARE_COMPONENT\"=?");
            for (Component component : COMPONENTS) {
                statement.setString(1, component.getName());
                statement.setString(2, component.getActivateString());
                statement.setString(3, component.getName());
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            LogFactory.writeLogEntry(this.getClass(), "Error inserting component into table " + this.sqlUser.getName().get() + "." + TABLE_NAME + ": " + e.getMessage() + "(SQL error code: " + e.getErrorCode() + ")");
            throw new HdbException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
    }

    private static class Component {
        private final String name;
        private final Boolean activate;

        public Component(String name) {
            this(name, Boolean.TRUE);
        }

        public Component(String name, Boolean activate) {
            this.name = name;
            this.activate = activate;
        }

        public String getName() {
            return this.name;
        }

        public String getActivateString() {
            return this.activate == null || this.activate == false ? "" : "X";
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Component)) {
                return false;
            }
            Component other = (Component)obj;
            return this.name == null ? other.name == null : this.name.equals(other.name);
        }

        public int hashCode() {
            int hashCode = 497;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }
    }
}

