/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class FindUnusedSchemaName
implements CmdClazz {
    private ResultFileWriter resultWriter = null;
    private Database database;
    private DatabaseSystemUser systemUser;
    private JdbcDriver jdbcDriver;
    private DatabaseSqlUser sqlUser;
    private JdbcConnection connection;

    protected FindUnusedSchemaName() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        this.connection.setConnectUser(this.systemUser);
        if (this.connection.isMultiDB() && !this.connection.doesTenantExist()) {
            this.resultWriter.append(this.sqlUser.getName().get());
            return;
        }
        if (!this.sqlUser.exists(this.connection, this.systemUser)) {
            this.resultWriter.append(this.sqlUser.getName().get());
            return;
        }
        if (this.sqlUser.getName().get().matches("DBACOCKPIT([A-Z][A-Z0-9]{2})?")) {
            this.resultWriter.append("DBACOCKPIT");
            return;
        }
        if (this.sqlUser.getName().get().matches("SAP[A-Z][A-Z0-9]{2}DB") || this.sqlUser.getName().get().startsWith("SAPJAVA")) {
            for (int i = 1; i < 10; ++i) {
                DatabaseSqlUserName userName = new DatabaseSqlUserName("SAPJAVA" + i);
                DatabaseSqlUser user = DatabaseSqlUserFactory.getUser(userName);
                if (user.exists(this.connection, this.systemUser)) continue;
                this.resultWriter.append(user.getName().get());
                return;
            }
        } else {
            for (int i = 1; i < 10; ++i) {
                DatabaseSqlUserName userName = new DatabaseSqlUserName("SAPABAP" + i);
                DatabaseSqlUser user = DatabaseSqlUserFactory.getUser(userName);
                if (user.exists(this.connection, this.systemUser)) continue;
                this.resultWriter.append(user.getName().get());
                return;
            }
        }
        this.resultWriter.append("");
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }

    public void setConnection(JdbcConnection connection) {
        this.connection = connection;
    }
}

