/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class FixCorruptedRowStoreTablesWithLOB
implements CmdClazz {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private DatabaseSqlUser sqlUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;

    protected FixCorruptedRowStoreTablesWithLOB() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        DatabaseSqlUserFactory.getUser(new DatabaseSqlUserName("_SYS_REPO"));
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
    }

    @Override
    public void execute() {
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        this.connection.setConnectUser(this.sqlUser);
        try {
            int i;
            Connection connection = this.connection.getConnection();
            Statement stmt = connection.createStatement();
            String sqlStmt = "SELECT TABLE_NAME FROM SYS.M_RS_TABLES  where SCHEMA_NAME = '" + this.sqlUser.getName().get() + "' AND  RECORD_COUNT > 0 ";
            ResultSet resultSet = stmt.executeQuery(sqlStmt);
            ArrayList<String> TabList = new ArrayList<String>();
            ArrayList<String> ColumnList = new ArrayList<String>();
            ArrayList<String> CorruptTables = new ArrayList<String>();
            while (resultSet.next()) {
                String Tabelle = resultSet.getString(1);
                TabList.add(Tabelle);
            }
            for (i = 0; i < TabList.size(); ++i) {
                String Table = (String)TabList.get(i);
                String LobChk = "SELECT COLUMN_NAME FROM SYS.TABLE_COLUMNS  WHERE SCHEMA_NAME = '" + this.sqlUser.getName().get() + "' AND TABLE_NAME = '" + Table + "' AND CS_DATA_TYPE_NAME = 'LOB'";
                ResultSet Columns = stmt.executeQuery(LobChk);
                ColumnList.clear();
                while (Columns.next()) {
                    String Column = Columns.getString(1);
                    ColumnList.add(Column);
                }
                boolean already_here = false;
                block10: for (int j = 0; j < ColumnList.size() && !already_here; ++j) {
                    sqlStmt = "SELECT \"" + (String)ColumnList.get(j) + "\" FROM \"" + Table + "\"";
                    ResultSet resultSetCheck = stmt.executeQuery(sqlStmt);
                    String corruptTab = null;
                    while (resultSetCheck.next()) {
                        try {
                            corruptTab = resultSetCheck.getString(1);
                        }
                        catch (OutOfMemoryError e) {
                            System.out.println("ignore OutOfMemoryError - record was too big for my heap size.");
                        }
                        catch (SQLException e1) {
                            CorruptTables.add(Table);
                            LogFactory.writeLogEntry(this.getClass(), "Corrupt data found in : " + Table.toString());
                            already_here = true;
                            continue block10;
                        }
                    }
                }
            }
            for (i = 0; i < CorruptTables.size(); ++i) {
                String corruptTab = (String)CorruptTables.get(i);
                this.connection.executeSQLCommandNoReslt("ALTER TABLE \"" + this.sqlUser.getName().get() + "\"." + corruptTab + " COLUMN");
                this.connection.executeSQLCommandNoReslt("ALTER TABLE \"" + this.sqlUser.getName().get() + "\"." + corruptTab + " ROW");
                System.out.println("Corrupt data fixed for :" + corruptTab.toString());
                LogFactory.writeLogEntry(this.getClass(), "Corrupt data fixed for : " + corruptTab.toString());
            }
        }
        catch (HdbException e) {
            int errorCode = this.connection.getErrorCode();
            if (errorCode != 334 && errorCode != 3841) {
                throw e;
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw e2;
        }
        catch (SQLException e3) {
            SQLException t = e3;
            LogFactory.writeLogEntry(this.getClass(), "An error occurred while executing SQL statement (" + t.getMessage() + ")");
            this.resultFileWriter.append(this.database.getHostname().get());
            throw new HdbException(e3);
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

