/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.SQLException;
import java.util.List;

public class GetAllDatabaseHosts
implements CmdClazz {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;

    protected GetAllDatabaseHosts() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        List<String> allHosts;
        try {
            if (null == this.connection) {
                this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
            }
            allHosts = this.database.getAllHosts(this.connection, this.systemUser);
        }
        catch (HdbException e) {
            Throwable t = e;
            while (t.getCause() instanceof HdbException) {
                t = t.getCause();
            }
            if (t.getCause() instanceof SQLException) {
                LogFactory.writeLogEntry(this.getClass(), "An error occurred while connecting to the database (" + t.getMessage() + "). Assuming the database will be installed and returning the host entered by the user.");
                this.resultFileWriter.append(this.database.getHostname().get());
                return;
            }
            throw e;
        }
        for (String host : allHosts) {
            String hostName = this.database.getPublicNameForHost(this.connection, this.systemUser, host);
            this.resultFileWriter.append(hostName);
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

