/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseTenant;
import com.sap.hdb.sl.lib.instance.Hostname;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.SystemDatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.SQLException;
import java.util.Set;

public class GetAllDatabaseHostsForTenant
implements CmdClazz {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseTenant tenantDatabase = null;
    private DatabaseSystemUser systemDatabaseUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private DatabaseSystemUser systemUser = null;
    private Sid databaseSid = null;

    protected GetAllDatabaseHostsForTenant() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.databaseSid = new Sid(parameters);
        if (parameters.containsKey(CmdClazzParameterName.SYSTEM_DATABASE_SYSTEM_USER_PASSWORD)) {
            this.systemDatabaseUser = SystemDatabaseSystemUserFactory.getUser(parameters);
        }
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        Set<Hostname> allHosts;
        try {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
            if (!this.connection.isMultiDB()) {
                throw new HdbException(CmdClazzName.GET_ALL_DATABASE_HOSTS_FOR_TENANT + ", CmdClazz requires a multi-tenant container systems.");
            }
            this.tenantDatabase = InstanceFactory.getDatabaseTenant(this.databaseSid, this.connection);
            allHosts = null != this.systemDatabaseUser ? this.tenantDatabase.getIndexserverHostsSystemDB(this.connection, this.systemDatabaseUser) : this.tenantDatabase.getIndexserverHosts(this.connection, this.systemUser);
        }
        catch (HdbException e) {
            Throwable t = e;
            while (t.getCause() instanceof HdbException) {
                t = t.getCause();
            }
            if (t.getCause() instanceof SQLException) {
                LogFactory.writeLogEntry(this.getClass(), "An error occurred while connecting to the database (" + t.getMessage() + "). Assuming the database will be installed and returning the host entered by the user.");
                this.resultFileWriter.append(this.database.getHostname().get());
                return;
            }
            throw e;
        }
        for (Hostname host : allHosts) {
            String hostName = this.tenantDatabase.getPublicNameForHost(this.connection, this.systemUser, host.get());
            this.resultFileWriter.append(hostName);
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

