/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabasePort;
import com.sap.hdb.sl.lib.instance.DatabaseTenant;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseConnectUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionResult;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.GetConnectHostsAndPorts;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.Arrays;
import java.util.List;

public class GetConnectHostsAndPortsMultiDB
extends BatchExecutionBase {
    private ResultFileWriter resultFileWriter;
    private Database systemDatabase = null;
    private DatabaseUser connectUser = null;
    private JdbcDriver jdbcDriver = null;
    private Sid tenantName = null;
    private String option = null;
    private boolean resolve_net_publicname = true;

    protected GetConnectHostsAndPortsMultiDB() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.tenantName = new Sid(parameters);
        this.systemDatabase = InstanceFactory.getSystemDatabaseInstance(parameters);
        this.connectUser = DatabaseConnectUserFactory.getConnectUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        if (parameters.containsKey(CmdClazzParameterName.ADD_OPTIONS)) {
            this.option = parameters.get(CmdClazzParameterName.ADD_OPTIONS).getValue();
        }
        this.parameters = parameters;
    }

    @Override
    public void execute() {
        String found;
        JdbcConnection connection;
        DatabaseTenant databaseTenant;
        if (null == this.resultKeeper) {
            this.resultKeeper = new BatchExecutionResult();
        }
        if (!(databaseTenant = InstanceFactory.getDatabaseTenant(this.tenantName, connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.systemDatabase))).tenantExists(connection, this.connectUser)) {
            throw new HdbException(this.tenantName.toString() + ", Database tenant does not exist!");
        }
        List<String> allHosts = databaseTenant.getAllHostsWithConfigRoleMaster(connection, this.connectUser);
        DatabasePort port = databaseTenant.getSqlPort(connection, this.connectUser);
        if (null != this.option && this.option.startsWith("resolve_net_publicname=") && ((found = this.option.substring(this.option.indexOf("=") + 1)).equals("false") || found.equals("0") || found.equals("no"))) {
            this.resolve_net_publicname = false;
            LogFactory.writeLogEntry(this.getClass(), "Function was called with option " + this.option + ". Will not resolve the hosts to net_publicname.");
        }
        String hostsString = "";
        for (String host : allHosts) {
            if (!this.resolve_net_publicname) {
                String hostWithPort = host + ":" + port.get();
                if (hostsString.length() > 0) {
                    hostsString = hostsString + ";" + hostWithPort;
                    continue;
                }
                hostsString = hostWithPort;
                continue;
            }
            String publicName = databaseTenant.getPublicNameForHost(connection, this.connectUser, host);
            if (publicName.length() <= 0) continue;
            String publicNameWithPort = publicName + ":" + port.get();
            if (hostsString.length() > 0) {
                hostsString = hostsString + ";" + publicNameWithPort;
                continue;
            }
            hostsString = publicNameWithPort;
        }
        LogFactory.writeLogEntry(this.getClass(), "HANA public name(s) resolution: " + Arrays.toString(hostsString.split(";")));
        String result = "";
        result = connection.testConnectionUrl("jdbc:sap://" + hostsString) ? hostsString : this.systemDatabase.getHostname().get() + ":" + port.get();
        if (null != this.resultFileWriter) {
            this.resultFileWriter.append(result.toString());
        }
        if (null != this.resultKeeper) {
            this.resultKeeper.addResult(GetConnectHostsAndPorts.CONNECT_HOSTS_AND_PORTS, result);
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

