/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseConnectUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public class GetConnectHostsAndPortsSingleDB
implements CmdClazz {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseUser connectUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;

    protected GetConnectHostsAndPortsSingleDB() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.connectUser = DatabaseConnectUserFactory.getConnectUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        List<String> allHosts;
        try {
            if (null == this.connection) {
                this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
            }
            allHosts = this.database.getAllHostsWithConfigRoleMaster(this.connection, this.connectUser);
        }
        catch (HdbException e) {
            if (e.getCause() instanceof SQLException) {
                LogFactory.writeLogEntry(this.getClass(), "An error occurred while connecting to the database (" + e.getMessage() + "). Assuming the database will be installed and returning the host entered by the user.");
                this.resultFileWriter.append(this.database.getHostname().get());
                return;
            }
            throw e;
        }
        String port = "3" + this.database.getNumber() + "15";
        String hostsString = "";
        for (String host : allHosts) {
            String publicName = this.database.getPublicNameForHost(this.connection, this.connectUser, host);
            if (publicName.length() <= 0) continue;
            String publicNameWithPort = publicName + ":" + port;
            if (hostsString.length() > 0) {
                hostsString = hostsString + ";" + publicNameWithPort;
                continue;
            }
            hostsString = publicNameWithPort;
        }
        LogFactory.writeLogEntry(this.getClass(), "HANA public name(s) resolution: " + Arrays.toString(hostsString.split(";")));
        if (this.connection.testConnectionUrl("jdbc:sap://" + hostsString)) {
            this.resultFileWriter.append(hostsString.split(";"));
        } else {
            this.resultFileWriter.append(this.database.getHostname().get() + ":" + port);
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

