/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseTenant;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseConnectUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.SQLException;
import java.util.List;

public class GetConnectHostsMultiDB
implements CmdClazz {
    private ResultFileWriter resultFileWriter;
    private Database systemDatabase = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private Sid tenantName = null;
    private DatabaseUser connectUser = null;

    protected GetConnectHostsMultiDB() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.tenantName = new Sid(parameters);
        this.systemDatabase = InstanceFactory.getSystemDatabaseInstance(parameters);
        this.connectUser = DatabaseConnectUserFactory.getConnectUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        List<String> allHosts;
        try {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.systemDatabase);
            DatabaseTenant databaseTenant = InstanceFactory.getDatabaseTenant(this.tenantName, this.connection);
            if (!databaseTenant.tenantExists(this.connection, this.connectUser)) {
                throw new HdbException(this.tenantName.toString() + ", Database tenant does not exist!");
            }
            allHosts = databaseTenant.getAllHostsWithConfigRoleMaster(this.connection, this.connectUser);
        }
        catch (HdbException e) {
            if (e.getCause() instanceof SQLException) {
                LogFactory.writeLogEntry(this.getClass(), "An error occurred while connecting to the database (" + e.getMessage() + "). Assuming the database will be installed and returning the host entered by the user.");
                this.resultFileWriter.append(this.systemDatabase.getHostname().get());
                return;
            }
            throw e;
        }
        for (String host : allHosts) {
            String hostName = this.systemDatabase.getPublicNameForHost(this.connection, this.connectUser, host);
            this.resultFileWriter.append(hostName);
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

