/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.SAPControlWsdlUrl;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.sapcontrol.SAPControlPortType;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.OperatingSystemUser;
import com.sap.hdb.sl.lib.user.OperatingSystemUserFactory;
import com.sap.hdb.sl.lib.user.SystemDatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.name.OperatingSystemUserName;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import com.sap.hdb.sl.lib.utils.SAPControlHelper;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.regex.Pattern;

public class GetDefaultDataBackupLocation
implements CmdClazz {
    private ResultFileWriter resultWriter;
    private Database database;
    private DatabaseSystemUser systemUser;
    private DatabaseSystemUser systemDatabaseSystemUser;
    private OperatingSystemUser osUser;
    private SAPControlWsdlUrl wsdlUrl;
    private JdbcDriver jdbcDriver;
    private String backupLocation;
    private SAPControlHelper helper = new SAPControlHelper();

    protected GetDefaultDataBackupLocation() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        if (parameters.containsKey(CmdClazzParameterName.SYSTEM_DATABASE_SYSTEM_USER_PASSWORD)) {
            this.systemDatabaseSystemUser = SystemDatabaseSystemUserFactory.getUser(parameters);
        }
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.osUser = OperatingSystemUserFactory.getUser(new OperatingSystemUserName(parameters.get(CmdClazzParameterName.SIDADM_ID).getValue()), PasswordFactory.getOperatingSystemUserPassword(parameters.get(CmdClazzParameterName.SIDADM_PASSWORD).getValue()));
        this.wsdlUrl = new SAPControlWsdlUrl(parameters);
    }

    public String getDefaultDataBackupLocation(SAPControlPortType port) {
        boolean onWindows;
        DatabaseConfiguration configuration;
        DatabaseConfigurationSection persistenceSection;
        String location;
        JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        DatabaseSystemUser connectUser = this.systemUser;
        connection.setConnectUser(connectUser);
        if (connection.isMultiDB()) {
            connectUser = this.systemDatabaseSystemUser;
            this.database.setSid(new Sid("SYSTEMDB"));
            connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        if ((location = (persistenceSection = (configuration = new DatabaseConfiguration(connection, connectUser, DatabaseConfiguration.ConfigFileName.GLOBAL_INI)).getSection("persistence")).getParameterValue("basepath_databackup")) == null) {
            throw new HdbException("Parameter '" + DatabaseConfiguration.ConfigFileName.GLOBAL_INI.toString() + " -> " + "persistence" + " -> basepath_databackup' is not set.");
        }
        LogFactory.writeLogEntry(this.getClass(), "Default database backup location: " + location);
        LogFactory.writeLogEntry(this.getClass(), "SAP Service for HANA version info: " + this.helper.getVersion(port));
        if (location.contains("$(DIR_INSTANCE)")) {
            String instanceDir = this.helper.getInstanceDirectory(port);
            LogFactory.writeLogEntry(this.getClass(), "Instance directory: " + instanceDir);
            if (instanceDir != null) {
                location = location.replaceAll(Pattern.quote("$(DIR_INSTANCE)"), instanceDir.replaceAll(Pattern.quote("\\"), "\\\\\\\\"));
                LogFactory.writeLogEntry(this.getClass(), "Processed database backup location: " + location);
            }
        }
        location = (onWindows = this.helper.onWindows(port)) ? location.replaceAll(Pattern.quote("/"), "\\\\") : location.replaceAll(Pattern.quote("\\"), "/");
        this.backupLocation = location;
        LogFactory.writeLogEntry(this.getClass(), "Returning as database backup location: " + location);
        return location;
    }

    public String getDefaultDataBackupLocation() {
        SAPControlPortType port = this.helper.getPort(this.wsdlUrl.getURL(), this.osUser.getName().get(), this.osUser.getPassword().get());
        return this.getDefaultDataBackupLocation(port);
    }

    @Override
    public void execute() {
        String location = this.getDefaultDataBackupLocation();
        if (location == null) {
            this.resultWriter.append(String.valueOf(false));
            return;
        }
        this.resultWriter.append(String.valueOf(true));
        this.resultWriter.append(location);
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }

    public String getCachedBackupLocation() {
        return this.backupLocation;
    }
}

