/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.BooleanParameter;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseXmlParameter;
import com.sap.hdb.sl.lib.instance.FileParameter;
import com.sap.hdb.sl.lib.instance.IntegerParameter;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class GetDefaultDatabaseParameters
implements CmdClazz {
    private static final Map<DatabaseConfiguration.ConfigFileName, Map<String, Map<String, String>>> DEFAULT_PARAMETER_VALUES = GetDefaultDatabaseParameters.loadDefaultParameterValues();
    private ResultFileWriter resultFileWriter;
    private boolean oneHost;
    private long totalMemory;
    private File xmlParameterFile;
    private boolean useXmlParameterFile = false;

    protected GetDefaultDatabaseParameters() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        if (parameters.containsKey(CmdClazzParameterName.ONE_HOST)) {
            this.oneHost = parameters.get(CmdClazzParameterName.ONE_HOST, BooleanParameter.class).getBooleanValue();
            if (this.oneHost) {
                this.totalMemory = parameters.get(CmdClazzParameterName.TOTAL_MEMORY_MB, IntegerParameter.class).getIntegerValue();
                if (this.totalMemory < 0L) {
                    throw new HdbException("The total amount of memory must not be negative.");
                }
            }
        }
        if (parameters.containsKey(CmdClazzParameterName.XML_PARAMETER_FILE)) {
            this.xmlParameterFile = parameters.get(CmdClazzParameterName.XML_PARAMETER_FILE, FileParameter.class).getFile();
            this.useXmlParameterFile = true;
            if (this.xmlParameterFile.exists()) {
                this.xmlParameterFile.delete();
            }
        }
    }

    private static Map<DatabaseConfiguration.ConfigFileName, Map<String, Map<String, String>>> loadDefaultParameterValues() {
        EnumMap defaultParameterValues = new EnumMap(DatabaseConfiguration.ConfigFileName.class);
        HashMap<String, String> parameterValueMap = new HashMap<String, String>();
        parameterValueMap.put("savepoint_interval_s", "300");
        HashMap<String, HashMap<String, String>> sectionMap = new HashMap<String, HashMap<String, String>>();
        sectionMap.put("persistence", parameterValueMap);
        defaultParameterValues.put(DatabaseConfiguration.ConfigFileName.GLOBAL_INI, sectionMap);
        parameterValueMap = new HashMap();
        parameterValueMap.put("num_merge_token", "200");
        parameterValueMap.put("token_per_table", "2");
        parameterValueMap.put("auto_merge_decision_func", "DMS>5000 and (DUC<0.1 or 0.05*DRC>=DUC)");
        parameterValueMap.put("critical_merge_decision_func", "DMS>12000 and (DUC<0.1 or 0.05*DRC>=DUC)");
        sectionMap = new HashMap();
        sectionMap.put("mergedog", parameterValueMap);
        parameterValueMap = new HashMap();
        parameterValueMap.put("min_hours_since_last_merge_of_part", "0");
        sectionMap.put("optimize_compression", parameterValueMap);
        defaultParameterValues.put(DatabaseConfiguration.ConfigFileName.INDEXSERVER_INI, sectionMap);
        return Collections.unmodifiableMap(defaultParameterValues);
    }

    private static Map<DatabaseConfiguration.ConfigFileName, Map<String, Map<String, String>>> log_modeParameterValues() {
        EnumMap defaultParameterValues = new EnumMap(DatabaseConfiguration.ConfigFileName.class);
        HashMap<String, String> parameterValueMap = new HashMap<String, String>();
        parameterValueMap.put("log_mode", "overwrite");
        HashMap<String, HashMap<String, String>> sectionMap = new HashMap<String, HashMap<String, String>>();
        sectionMap.put("persistence", parameterValueMap);
        defaultParameterValues.put(DatabaseConfiguration.ConfigFileName.GLOBAL_INI, sectionMap);
        return Collections.unmodifiableMap(defaultParameterValues);
    }

    @Override
    public void execute() {
        if (this.useXmlParameterFile) {
            this.appendXmlParameterFile("<?xml version=\"1.0\" encoding=\"utf-8\"?><Parameters>");
        }
        this.addParameters(DatabaseXmlParameter.DEFAULT_PARAMETER_VALUES, true);
        if (this.oneHost) {
            long global_allocation_limit = Math.round((double)this.totalMemory * 0.8);
            this.resultFileWriter.append("\"" + (Object)((Object)DatabaseConfiguration.ConfigFileName.GLOBAL_INI) + "\",\"memorymanager\",\"global_allocation_limit\",\"" + global_allocation_limit + "\",\"true\"");
        }
        this.addParameters(DEFAULT_PARAMETER_VALUES, false);
        this.addParameters(GetDefaultDatabaseParameters.log_modeParameterValues(), false);
        if (this.useXmlParameterFile) {
            this.appendXmlParameterFile("</Parameters>");
        }
    }

    private void addParameters(Map<DatabaseConfiguration.ConfigFileName, Map<String, Map<String, String>>> parameterValues, boolean permanent) {
        for (Map.Entry<DatabaseConfiguration.ConfigFileName, Map<String, Map<String, String>>> configFileEntry : parameterValues.entrySet()) {
            DatabaseConfiguration.ConfigFileName configFileName = configFileEntry.getKey();
            for (Map.Entry<String, Map<String, String>> sectionEntry : configFileEntry.getValue().entrySet()) {
                String section = sectionEntry.getKey();
                for (Map.Entry<String, String> parameterEntry : sectionEntry.getValue().entrySet()) {
                    if (parameterEntry.getValue() == null) continue;
                    String parameterName = parameterEntry.getKey();
                    String parameterValue = parameterEntry.getValue().replaceAll(Pattern.quote("\""), "\"\"");
                    this.resultFileWriter.append("\"" + configFileName.toString() + "\",\"" + section + "\",\"" + parameterName + "\",\"" + parameterValue + "\",\"" + String.valueOf(permanent) + "\"");
                    if (!this.useXmlParameterFile) continue;
                    this.appendXmlParameterFile("<Parameter><ConfigurationFile>" + configFileName.toString() + "</ConfigurationFile>" + "<Section>" + section + "</Section>" + "<ParameterName>" + parameterName + "</ParameterName>" + "<ParameterValue><![CDATA[" + parameterValue + "]]></ParameterValue>" + "<Persistent>" + String.valueOf(permanent) + "</Persistent></Parameter>");
                }
            }
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }

    private void appendXmlParameterFile(String line) {
        PrintWriter pW = null;
        FileWriter fW = null;
        try {
            fW = new FileWriter(this.xmlParameterFile, true);
            pW = new PrintWriter(fW);
            pW.println(line);
            pW.flush();
        }
        catch (IOException e) {
            throw new HdbException(e);
        }
        finally {
            if (null != pW) {
                pW.close();
                try {
                    fW.close();
                }
                catch (IOException e) {
                    LogFactory.writeLogEntry(this.getClass(), e.getMessage());
                }
            }
        }
    }
}

