/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.instance.InstallationPath;
import com.sap.hdb.sl.lib.instance.Instance;
import com.sap.hdb.sl.lib.instance.InstanceGroup;
import com.sap.hdb.sl.lib.instance.InstanceNumber;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.utils.HdbInstExecutable;
import com.sap.hdb.sl.lib.utils.SystemInformation;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class GetInstance
implements CmdClazz {
    private ResultFileWriter resultWriter = null;
    private HdbInstExecutable hdbInstExe = null;
    private Sid sid = null;
    private Instance.Type instanceType = null;
    private String delim = null;

    protected GetInstance() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.hdbInstExe = (HdbInstExecutable)parameters.get(CmdClazzParameterName.HDBINSTEXE);
        this.sid = (Sid)parameters.get(CmdClazzParameterName.DATABASE_SID);
        CmdClazzParameter type = parameters.get(CmdClazzParameterName.INSTANCE_TYPE);
        this.instanceType = Instance.Type.valueOf(type.getValue());
        CmdClazzParameter parameter = parameters.get(CmdClazzParameterName.DELIM);
        this.delim = parameter.getValue();
    }

    @Override
    public void execute() {
        SystemInformation info = new SystemInformation(this.hdbInstExe);
        this.createInformation(info);
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }

    public void execute(SystemInformation info) {
        this.createInformation(info);
    }

    private void createInformation(SystemInformation info) {
        InstanceGroup group = info.getInstanceGroup(this.sid);
        Instance instance = group.getInstance(this.instanceType);
        InstallationPath path = group.getInstallationPath();
        InstanceGroup.Description description = group.getDescription();
        String version = null;
        String host = null;
        InstanceNumber number = instance.getNumber();
        switch (this.instanceType) {
            case HDB: {
                version = instance.getVersion().get();
                host = instance.getHostname().get();
                break;
            }
            default: {
                version = " ";
                host = " ";
            }
        }
        this.resultWriter.append(this.sid + this.delim + (Object)((Object)instance.getType()) + this.delim + number + this.delim + path + this.delim + (Object)((Object)description) + this.delim + host + this.delim + version);
    }
}

