/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseVolume;
import com.sap.hdb.sl.lib.instance.DatabaseVolumeFactory;
import com.sap.hdb.sl.lib.instance.DatabaseVolumeList;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.LiveCache;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class GetLiveCacheNode
implements CmdClazz {
    private ResultFileWriter resultWriter = null;
    private LiveCache liveCache = null;
    private DatabaseSystemUser systemUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private Database database = null;

    protected GetLiveCacheNode() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.liveCache = InstanceFactory.getLiveCacheInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.database = InstanceFactory.getDatabaseInstance(parameters);
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.liveCache);
        }
        DatabaseVolumeList volumeList = DatabaseVolumeFactory.getInstance(this.connection, this.systemUser);
        DatabaseVolume volume = this.liveCache.getStore(volumeList);
        String hostName = this.database.getPublicNameForHost(this.connection, this.systemUser, volume.getHostname().get());
        String internal_port = String.valueOf(volume.getPort().getAsInteger());
        String sqlPort = this.getSqlPort(volume.getHostname().get(), internal_port);
        this.resultWriter.append(hostName);
        this.resultWriter.append(volume.getLiveCacheStore().toString());
        this.resultWriter.append(sqlPort);
    }

    private String getSqlPort(String hostname, String port) {
        String sqlPort = null;
        PreparedStatement statement = this.connection.prepareSQLCommand("select SQL_PORT from M_SERVICES where HOST=? and PORT=?");
        try {
            statement.setString(1, hostname);
            statement.setString(2, port);
        }
        catch (SQLException e) {
            throw new HdbException(e.getMessage(), e);
        }
        List<String> result = this.connection.executeSQLCommand(statement);
        if (result.size() != 1) {
            throw new HdbException(result + " Wrong result count for SQL query: " + statement);
        }
        sqlPort = result.get(0);
        return sqlPort;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }

    public void setJdbcConnection(JdbcConnection connection) {
        this.connection = connection;
    }
}

