/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.PasswordPolicy;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class GetMinimalPasswordLength
implements CmdClazz {
    private ResultFileWriter resultWriter = null;
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private int MinimalPasswordLength = 8;

    protected GetMinimalPasswordLength() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        int PasswordLengthSetInDb;
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        this.connection.setConnectUser(this.systemUser);
        String tenantMinLength = PasswordPolicy.getParameterValue(this.connection, this.systemUser, "minimal_password_length");
        String systemDbMinLength = "0";
        if (this.connection.isConnectedToSystemDB()) {
            systemDbMinLength = PasswordPolicy.getSystemDbParameterValue(this.connection, this.systemUser, "minimal_password_length");
        }
        if ((PasswordLengthSetInDb = Math.max(Integer.parseInt(tenantMinLength), Integer.parseInt(systemDbMinLength))) > 8) {
            this.MinimalPasswordLength = PasswordLengthSetInDb;
        }
        this.resultWriter.append(String.valueOf(true));
        this.resultWriter.append(String.valueOf(this.MinimalPasswordLength));
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }
}

