/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.utils.IOUtils;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class GetSapReleaseFromDB
implements CmdClazz {
    private Database database;
    private JdbcDriver jdbcDriver;
    private DatabaseSqlUser sqlUser;
    private ResultFileWriter resultFileWriter;

    protected GetSapReleaseFromDB() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
    }

    @Override
    public void execute() {
        ResultSet resultSet;
        PreparedStatement statement;
        block5: {
            JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
            connection.setConnectUser(this.sqlUser);
            statement = null;
            resultSet = null;
            try {
                statement = connection.prepareSQLCommand("SELECT \"RELEASE\", \"EXTRELEASE\" FROM CVERS WHERE COMPONENT='SAP_BASIS'");
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    int rel = resultSet.getInt(1);
                    int sp = resultSet.getInt(2);
                    this.resultFileWriter.append(String.valueOf(true));
                    this.resultFileWriter.append(String.valueOf(rel));
                    this.resultFileWriter.append(String.valueOf(sp));
                    break block5;
                }
                LogFactory.writeLogEntry(this.getClass(), "Unable to determine SAP release. No information found in schema " + this.sqlUser.getName().get() + ".");
                this.resultFileWriter.append(String.valueOf(false));
            }
            catch (SQLException e) {
                try {
                    LogFactory.writeLogEntry(this.getClass(), "Error determining SAP release: " + e.getMessage() + "(SQL error code: " + e.getErrorCode() + ")");
                    throw new HdbException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(resultSet);
                    IOUtils.closeQuietly(statement);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly(resultSet);
        IOUtils.closeQuietly(statement);
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

