/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabasePort;
import com.sap.hdb.sl.lib.instance.DatabaseTenant;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class GetSqlPortOnMultiDB
implements CmdClazz {
    private Database database;
    private JdbcDriver jdbcDriver;
    private DatabaseSystemUser systemUser;
    private ResultFileWriter resultFileWriter;
    private Sid tenantName;

    protected GetSqlPortOnMultiDB() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getSystemDatabaseInstance(parameters);
        this.tenantName = new Sid(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
    }

    @Override
    public void execute() {
        JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        connection.setConnectUser(this.systemUser);
        DatabaseTenant databaseTenant = InstanceFactory.getDatabaseTenant(this.tenantName, connection);
        if (!databaseTenant.tenantExists(connection, this.systemUser)) {
            throw new HdbException(this.tenantName.toString() + ", Database tenant does not exist!");
        }
        DatabasePort sqlPort = databaseTenant.getSqlPort(connection, this.systemUser);
        this.resultFileWriter.append(sqlPort.get());
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

