/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.InstallationPath;
import com.sap.hdb.sl.lib.instance.Instance;
import com.sap.hdb.sl.lib.instance.InstanceGroup;
import com.sap.hdb.sl.lib.instance.InstanceNumber;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.utils.HdbInstExecutable;
import com.sap.hdb.sl.lib.utils.SystemInformation;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.List;

public class GetSystems
implements CmdClazz {
    private HdbInstExecutable hdbInstExecutable = null;
    private String delim = null;
    private ResultFileWriter resultFile = null;

    protected GetSystems() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        CmdClazzParameter parameter = parameters.get(CmdClazzParameterName.HDBINSTEXE);
        if (!(parameter instanceof HdbInstExecutable)) {
            throw new HdbException(CmdClazzParameterName.HDBINSTEXE.toString() + " must be instance of " + HdbInstExecutable.class.getName());
        }
        this.hdbInstExecutable = (HdbInstExecutable)parameter;
        parameter = parameters.get(CmdClazzParameterName.DELIM);
        this.delim = parameter.getValue();
    }

    @Override
    public void execute() {
        SystemInformation systemInformation = new SystemInformation(this.hdbInstExecutable);
        List<InstanceGroup> instances = systemInformation.getInstanceGroups();
        for (InstanceGroup instanceGroup : instances) {
            Sid sid = instanceGroup.getSid();
            InstallationPath path = instanceGroup.getInstallationPath();
            InstanceGroup.Description description = instanceGroup.getDescription();
            for (Instance.Type type : Instance.Type.values()) {
                String version = null;
                String host = null;
                if (!instanceGroup.containsInstance(type)) continue;
                Instance instance = instanceGroup.getInstance(type);
                InstanceNumber number = instance.getNumber();
                switch (type) {
                    case HDB: {
                        version = instance.getVersion().get();
                        host = instance.getHostname().get();
                        break;
                    }
                    default: {
                        version = " ";
                        host = " ";
                    }
                }
                this.resultFile.append(sid + this.delim + (Object)((Object)instance.getType()) + this.delim + number + this.delim + path + this.delim + (Object)((Object)description) + this.delim + host + this.delim + version);
            }
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFile = writer;
    }
}

