/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.DatabaseUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class GetTenantClientPKI
implements CmdClazz {
    private Database database;
    private Database databaseNoEncrypt;
    private JdbcDriver jdbcDriver;
    private DatabaseUser sqlUser;
    private ResultFileWriter resultFileWriter;

    protected GetTenantClientPKI() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        if (this.database.isEncryptTrue()) {
            this.databaseNoEncrypt = InstanceFactory.getDatabaseInstance(parameters);
            this.databaseNoEncrypt.setEncrypt("false");
            this.databaseNoEncrypt.setEncryptProperties("encrypt=false");
        }
        this.jdbcDriver = new JdbcDriver(parameters);
        this.sqlUser = DatabaseUserFactory.getUser(parameters);
    }

    @Override
    public void execute() {
        JdbcConnection connection = this.getValidConnection();
        String cetificate = null;
        if (this.database.supportsClientPKI(connection)) {
            cetificate = this.database.getPKI(connection, true);
            if (cetificate == null) {
                LogFactory.writeLogEntry(this.getClass(), "Client PKI supported but was not found.");
            }
        } else {
            LogFactory.writeLogEntry(this.getClass(), "Client PKI not required for server authentication.");
        }
        if (cetificate == null) {
            this.resultFileWriter.append(String.valueOf(false));
        } else {
            this.resultFileWriter.append(String.valueOf(true));
            this.resultFileWriter.append(cetificate);
        }
    }

    private JdbcConnection getValidConnection() {
        JdbcConnection connection;
        block10: {
            connection = JdbcConnectionFactory.resetInstance(this.jdbcDriver, this.database);
            try {
                connection.setUserAndConnect(this.sqlUser);
            }
            catch (HdbException e) {
                if (e.getMessage() != null && e.getMessage().indexOf("unrecognized_name") > -1) {
                    if (!this.database.isEncryptTrue()) break block10;
                    LogFactory.writeLogEntry(this.getClass(), "Connection with encryption fails. The clientpki is not created. Retry connect without encryption.");
                    if (this.databaseNoEncrypt != null) {
                        connection = this.getConnectionNoEncrypt();
                    }
                    if (!connection.isClosed()) break block10;
                    LogFactory.writeLogEntry(this.getClass(), "Wait for clientpki recreation.");
                    int retry = 1;
                    connection = JdbcConnectionFactory.resetInstance(this.jdbcDriver, this.database);
                    do {
                        try {
                            Thread.sleep(30000L);
                            LogFactory.writeLogEntry(this.getClass(), "Check connection with encryption retry #" + retry);
                            connection.setUserAndConnect(this.sqlUser);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                            break block10;
                        }
                        catch (HdbException e2) {
                            if (e2.getMessage() == null || e2.getMessage().indexOf("unrecognized_name") == -1) break block10;
                        }
                    } while (++retry <= 60 && connection.isClosed());
                }
                throw e;
            }
        }
        if (connection.isClosed()) {
            LogFactory.writeLogEntry(this.getClass(), "Connection was not successful. Check SAP note 3132735 for more information.");
        }
        return connection;
    }

    private JdbcConnection getConnectionNoEncrypt() {
        JdbcConnection connection = JdbcConnectionFactory.resetInstance(this.jdbcDriver, this.databaseNoEncrypt);
        try {
            connection.setUserAndConnect(this.sqlUser);
        }
        catch (HdbException e) {
            LogFactory.writeLogEntry(this.getClass(), "Connection without encryption is not possible: " + e.getMessage());
        }
        return connection;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

