/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.hdbmonitor.HDBLoadHistoryMonitor;
import com.sap.hdb.sl.lib.hdbmonitor.HDBMonitorParams;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseConnectUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class HDBMonitor
implements CmdClazz {
    private Database database = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private DatabaseUser connectUser = null;
    private String keeprunning = "true";
    private File logDir = null;
    private File anaDir = null;
    private File outFile = null;
    String sleep = "120";
    private ResultFileWriter resultFileWriter;
    private static String HDBMONITOR_CSV = "HDBMONITOR.CSV";

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.connectUser = DatabaseConnectUserFactory.getConnectUser(parameters);
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        this.readParams(parameters);
    }

    @Override
    public void execute() {
        this.connection.setConnectUser(this.connectUser);
        HDBMonitorParams params = new HDBMonitorParams();
        params.setLogDir(this.logDir);
        params.setAnapath(this.anaDir);
        params.setKeeprunning(this.keeprunning);
        params.setSleep(this.sleep);
        params.setConnection(this.connection);
        if (null == this.outFile) {
            this.outFile = new File(this.anaDir, HDBMONITOR_CSV);
        }
        params.setOutFile(this.outFile);
        if (!this.outFile.exists()) {
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(this.outFile, true));
                bw.append("#HOST:TIMESTAMP:USED_MEMORY:MAX_MEMORY:CPU:DISK_USED_MB:DISK_SIZE_MB:PHASE");
                bw.newLine();
                bw.flush();
                bw.close();
            }
            catch (IOException e) {
                LogFactory.writeLogExceptionEntry(this.getClass(), e.getMessage(), "Could not read / write files!");
            }
        }
        HDBLoadHistoryMonitor monitor = new HDBLoadHistoryMonitor(params);
        monitor.monitor();
        this.resultFileWriter.append("true");
    }

    public void readParams(CmdClazzParameterMap parameters) {
        this.setjdbcDriver(parameters);
        File bin = this.jdbcDriver.get().getParentFile();
        LogFactory.writeLogEntry(this.getClass(), "bin=" + bin.getAbsolutePath());
        File doc = new File(bin.getParentFile(), "doc");
        LogFactory.writeLogEntry(this.getClass(), "doc=" + doc.getAbsolutePath());
        this.anaDir = new File(doc, "analysis");
        LogFactory.writeLogEntry(this.getClass(), "anaDir=" + this.anaDir.getAbsolutePath());
        this.readHdbmonParams(parameters);
    }

    public void setjdbcDriver(CmdClazzParameterMap parameters) {
        if (parameters.containsKey(CmdClazzParameterName.JDBC_PATH)) {
            this.jdbcDriver = new JdbcDriver(parameters);
        } else {
            File jarFile = new File("ngdbc.jar");
            if (jarFile.exists()) {
                this.jdbcDriver = new JdbcDriver(jarFile);
            } else {
                throw new HdbException("Could not find jdbc driver in " + jarFile.getAbsolutePath() + ". Provide JDBC_PATH parameter.");
            }
        }
    }

    public void readHdbmonParams(CmdClazzParameterMap parameters) {
        String[] parts;
        if (!parameters.containsKey(CmdClazzParameterName.ADD_OPTIONS)) {
            return;
        }
        String hdbmonParams = parameters.get(CmdClazzParameterName.ADD_OPTIONS).getValue();
        LogFactory.writeLogEntry(this.getClass(), "Received hdbmonitor parameteres: " + hdbmonParams);
        hdbmonParams.trim();
        for (String option : parts = hdbmonParams.split(",")) {
            if (option.startsWith("outfile=")) {
                this.outFile = new File(option.substring(option.indexOf("=") + 1));
                LogFactory.writeLogEntry(this.getClass(), "Using outfile: " + this.outFile);
                continue;
            }
            if (option.startsWith("sleep=")) {
                this.sleep = option.substring(option.indexOf("=") + 1);
                LogFactory.writeLogEntry(this.getClass(), "Using sleep: " + this.sleep + " seconds");
                continue;
            }
            if (option.startsWith("keeprunning=")) {
                this.keeprunning = option.substring(option.indexOf("=") + 1);
                LogFactory.writeLogEntry(this.getClass(), "Using keeprunning: " + this.keeprunning);
                continue;
            }
            LogFactory.writeLogEntry(this.getClass(), "Unknown option " + option);
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

