/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.hdi.HDIConstants;
import com.sap.hdb.sl.lib.hdi.HDIHelper;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.List;

public class HDICheck
extends BatchExecutionBase
implements CmdClazz {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseSqlUser databaseUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    String htaTableExists = "false";
    String containerSetInHta = "false";
    String isDiserverAcive = "false";

    protected HDICheck() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.databaseUser = DatabaseSqlUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        this.connection.setConnectUser(this.databaseUser);
        String containerName = null;
        String cvers_basis = HDIHelper.checkCVERSBasis(this.connection, this.databaseUser);
        if (HDIHelper.tableExists(this.connection, "CTS_HOT_CONFIG")) {
            this.htaTableExists = "true";
            containerName = this.getContainerFromHtaTable();
            if (null != containerName) {
                this.containerSetInHta = "true";
            }
        }
        String hdiEnabled = "false";
        if (null != containerName && this.makeOtherChecks(containerName)) {
            hdiEnabled = "true";
        }
        this.checkDiserver();
        if (null != this.resultFileWriter) {
            this.resultFileWriter.append(hdiEnabled);
            this.resultFileWriter.append(HDIConstants.CONTAINER_GROUP_NAME + "=" + containerName);
            this.resultFileWriter.append(HDIConstants.CONTAINER_GROUP_SET_IN_HTA + "=" + this.containerSetInHta);
            this.resultFileWriter.append(HDIConstants.DISERVER_IS_ACTIVE + "=" + this.isDiserverAcive);
            this.resultFileWriter.append(HDIConstants.SAP_BASIS + "=" + cvers_basis);
            this.resultFileWriter.append(HDIConstants.HTA_TABLE_EXISTS + "=" + this.htaTableExists);
        }
        if (null != this.resultKeeper) {
            this.resultKeeper.addResult(HDIConstants.HDI_ENABLED, hdiEnabled);
            this.resultKeeper.addResult(HDIConstants.CONTAINER_GROUP_NAME, containerName);
            this.resultKeeper.addResult(HDIConstants.CONTAINER_GROUP_SET_IN_HTA, this.containerSetInHta);
            this.resultKeeper.addResult(HDIConstants.DISERVER_IS_ACTIVE, this.isDiserverAcive);
            this.resultKeeper.addResult(HDIConstants.SAP_BASIS, cvers_basis);
            this.resultKeeper.addResult(HDIConstants.HTA_TABLE_EXISTS, this.htaTableExists);
        }
    }

    private void checkDiserver() {
        if (this.connection.isHANA4orNewer()) {
            LogFactory.writeLogEntry(this.getClass(), "Service 'diserver' always available on HANA Cloud Edition.");
            this.isDiserverAcive = "true";
        } else {
            List<String> result = this.connection.executeSQLCommand("SELECT COUNT(*) FROM PUBLIC.M_SERVICES WHERE SERVICE_NAME='diserver' AND ACTIVE_STATUS='YES'");
            if (result.get(0).equals("1")) {
                this.isDiserverAcive = "true";
            }
        }
    }

    private boolean makeOtherChecks(String containerName) {
        boolean privilegOnSysDiTable;
        boolean contGroupSchemaExists;
        boolean sysDiSchemaExists;
        block5: {
            sysDiSchemaExists = false;
            contGroupSchemaExists = false;
            privilegOnSysDiTable = false;
            List<String> result = this.connection.executeSQLCommand("SELECT count(*) FROM SYS.SCHEMAS WHERE SCHEMA_NAME = '_SYS_DI'");
            if (result.get(0).equals("1")) {
                sysDiSchemaExists = true;
            }
            if (sysDiSchemaExists) {
                String containerGroupSchema = "_SYS_DI#" + containerName;
                result = this.connection.executeSQLCommand("SELECT COUNT(*) FROM SYS.SCHEMAS WHERE SCHEMA_NAME = '" + containerGroupSchema + "' " + "AND HAS_PRIVILEGES = 'TRUE'");
                if (result.get(0).equals("1")) {
                    contGroupSchemaExists = true;
                }
            }
            try {
                this.connection.executeSQLCommand("select * from \"_SYS_DI\".\"T_DEFAULT_CONTAINER_GROUP_ADMIN_PRIVILEGES\"");
                privilegOnSysDiTable = true;
            }
            catch (HdbException e) {
                if (!e.testInsufficientPrivilege()) break block5;
                privilegOnSysDiTable = false;
            }
        }
        return sysDiSchemaExists && contGroupSchemaExists && privilegOnSysDiTable;
    }

    private String getContainerFromHtaTable() {
        List<String> result = this.connection.executeSQLCommand("SELECT VALUE from CTS_HOT_CONFIG WHERE NAME = 'HDI_CONTAINER_GROUP'");
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

