/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.hdi.HDIConstants;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionResult;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class HDICheckEnable
extends BatchExecutionBase {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseSqlUser databaseUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;

    protected HDICheckEnable() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.parameters = parameters;
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        if (null == this.resultKeeper) {
            this.resultKeeper = new BatchExecutionResult();
        }
        this.executeCmdClazz(CmdClazzName.HDI_CHECK);
        if (this.resultKeeper.getResult(HDIConstants.HDI_ENABLED).equalsIgnoreCase("false") && this.sapBasisNeedsHdi(this.resultKeeper.getResult(HDIConstants.SAP_BASIS))) {
            this.executeCmdClazz(CmdClazzName.CREATE_HDI_CONTAINER_GROUP_ADD_PRIVILEGES);
        }
        if (this.resultKeeper.getResult(HDIConstants.HTA_TABLE_EXISTS).equalsIgnoreCase("true") && this.resultKeeper.getResult(HDIConstants.CONTAINER_GROUP_SET_IN_HTA).equalsIgnoreCase("false") && this.parameters.containsKey(CmdClazzParameterName.HDI_SET_CONTAINER_GROUP_IN_HTA) && this.parameters.get(CmdClazzParameterName.HDI_SET_CONTAINER_GROUP_IN_HTA).getValue().equalsIgnoreCase("true")) {
            this.setContainerGroupInHta(this.resultKeeper.getResult(HDIConstants.CONTAINER_GROUP_NAME));
        }
        if (this.resultKeeper.getResult(HDIConstants.DISERVER_IS_ACTIVE).equalsIgnoreCase("false")) {
            if (this.connection.isMultiDB()) {
                if (this.parameters.containsKey(CmdClazzParameterName.SYSTEM_DATABASE_SYSTEM_USER_PASSWORD)) {
                    this.executeCmdClazz(CmdClazzName.TURN_ON_HDI_MULTI_DB);
                } else {
                    LogFactory.writeLogEntry(this.getClass(), "Could not turn on HDI. Missing SYSTEM_DATABASE_SYSTEM_USER_PASSWORD.");
                }
            } else {
                this.executeCmdClazz(CmdClazzName.TURN_ON_HDI_SINGLE_DB);
            }
        }
        if (null != this.resultFileWriter) {
            this.resultFileWriter.append(this.resultKeeper.getResult(HDIConstants.HDI_ENABLED));
            this.resultFileWriter.append(HDIConstants.CONTAINER_GROUP_NAME + "=" + this.resultKeeper.getResult(HDIConstants.CONTAINER_GROUP_NAME));
            this.resultFileWriter.append(HDIConstants.CONTAINER_GROUP_SET_IN_HTA + "=" + this.resultKeeper.getResult(HDIConstants.CONTAINER_GROUP_SET_IN_HTA));
            this.resultFileWriter.append(HDIConstants.DISERVER_IS_ACTIVE + "=" + this.resultKeeper.getResult(HDIConstants.DISERVER_IS_ACTIVE));
            this.resultFileWriter.append(HDIConstants.SAP_BASIS + "=" + this.resultKeeper.getResult(HDIConstants.SAP_BASIS));
            this.resultFileWriter.append(HDIConstants.HTA_TABLE_EXISTS + "=" + this.resultKeeper.getResult(HDIConstants.HTA_TABLE_EXISTS));
        }
    }

    private void setContainerGroupInHta(String containerName) {
        this.databaseUser = DatabaseSqlUserFactory.getUser(this.parameters);
        this.connection.setConnectUser(this.databaseUser);
        try {
            this.connection.executeSQLCommandNoReslt("INSERT INTO CTS_HOT_CONFIG VALUES ('ALL', 'HDI_CONTAINER_GROUP', '" + containerName + "', TO_DECIMAL(TO_VARCHAR(CURRENT_TIMESTAMP, 'YYYYMMDDhhmmss.FF1'), 15, 0), 'HDBSLLIB')");
            this.resultKeeper.addResult(HDIConstants.CONTAINER_GROUP_SET_IN_HTA, "true");
        }
        catch (HdbException e) {
            LogFactory.writeLogEntry(this.getClass(), "Could not set container group name " + containerName + " in HTA. " + e.getMessage());
        }
    }

    private boolean sapBasisNeedsHdi(String versionStr) {
        int version = 0;
        try {
            version = Integer.parseInt(versionStr);
        }
        catch (NumberFormatException e) {
            LogFactory.writeLogEntry(this.getClass(), "Could not parse SAP_BASIS release to int, read from CVERS " + versionStr);
            return false;
        }
        return version >= 752 && version <= 759 || version >= 769;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

