/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.hdi.HDIConstants;
import com.sap.hdb.sl.lib.hdi.HDIHelper;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionResult;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class HDICheckRepairPrivileges
extends BatchExecutionBase {
    private Database database = null;
    private DatabaseSqlUser databaseUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private DatabaseSystemUser systemUser = null;

    protected HDICheckRepairPrivileges() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.parameters = parameters;
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        this.databaseUser = DatabaseSqlUserFactory.getUser(this.parameters);
        String sap_basis = HDIHelper.checkCVERSBasis(this.connection, this.databaseUser);
        if (!HDIHelper.sapBasisNeedsHdi(sap_basis)) {
            return;
        }
        this.resultKeeper = new BatchExecutionResult();
        this.executeCmdClazz(CmdClazzName.HDI_CHECK);
        if (this.resultKeeper.getResult(HDIConstants.HDI_ENABLED).equalsIgnoreCase("false") && HDIHelper.sapBasisNeedsHdi(this.resultKeeper.getResult(HDIConstants.SAP_BASIS)) && this.resultKeeper.getResult(HDIConstants.HTA_TABLE_EXISTS).equalsIgnoreCase("true") && this.resultKeeper.getResult(HDIConstants.CONTAINER_GROUP_SET_IN_HTA).equalsIgnoreCase("true")) {
            this.systemUser = DatabaseSystemUserFactory.getUser(this.parameters);
            this.connection.setConnectUser(this.systemUser);
            String containerGroupNameInHTA = this.resultKeeper.getResult(HDIConstants.CONTAINER_GROUP_NAME);
            HDIHelper.grantPrivileges(this.connection, containerGroupNameInHTA, this.databaseUser);
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
    }
}

