/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.hdi.HDIConstants;
import com.sap.hdb.sl.lib.hdi.HDIHelper;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.HDICreateContainerGroupAddPrivilegesSQLs;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class HDICreateContainerGroupAddPrivileges
extends BatchExecutionBase {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseSqlUser databaseUser = null;
    private DatabaseSystemUser systemUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private String containerGroupName = null;
    public static String SYSTEM_DATABASE_SYSTEM_PASSWORD_MISSING = "SYSTEM_DATABASE_SYSTEM_PASSWORD_MISSING";

    protected HDICreateContainerGroupAddPrivileges() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.databaseUser = DatabaseSqlUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.parameters = parameters;
    }

    @Override
    public void execute() {
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        this.connection.setConnectUser(this.systemUser);
        if (this.connection.isHANA4orNewer()) {
            LogFactory.writeLogEntry(this.getClass(), "Service 'diserver' always available on HANA Cloud Edition.");
        } else {
            List<String> result = this.connection.executeSQLCommand(HDICreateContainerGroupAddPrivilegesSQLs.DISERVER_CHECK_SQL);
            if (result.get(0).equalsIgnoreCase("0")) {
                if (this.connection.isMultiDB()) {
                    if (this.parameters.containsKey(CmdClazzParameterName.SYSTEM_DATABASE_SYSTEM_USER_PASSWORD)) {
                        this.executeCmdClazz(CmdClazzName.TURN_ON_HDI_MULTI_DB);
                    } else {
                        if (null != this.resultFileWriter) {
                            this.resultFileWriter.append("false");
                            this.resultFileWriter.append(SYSTEM_DATABASE_SYSTEM_PASSWORD_MISSING);
                            return;
                        }
                        if (null != this.resultKeeper) {
                            this.resultKeeper.addResult(HDIConstants.HDI_ENABLED, "false");
                            this.resultKeeper.addResult(HDIConstants.DISERVER_IS_ACTIVE, "false");
                            return;
                        }
                    }
                } else {
                    this.executeCmdClazz(CmdClazzName.TURN_ON_HDI_SINGLE_DB);
                }
            }
        }
        if (this.shouldCreateContainerGroup()) {
            this.createContainerGroup();
        }
        if (0 == HDIHelper.grantPrivileges(this.connection, this.containerGroupName, this.databaseUser)) {
            if (null != this.resultFileWriter) {
                this.resultFileWriter.append("true");
                this.resultFileWriter.append(this.containerGroupName);
            }
            if (null != this.resultKeeper) {
                this.resultKeeper.addResult(HDIConstants.HDI_ENABLED, "true");
                this.resultKeeper.addResult(HDIConstants.CONTAINER_GROUP_NAME, this.containerGroupName);
                this.resultKeeper.addResult(HDIConstants.DISERVER_IS_ACTIVE, "true");
            }
        } else {
            if (null != this.resultFileWriter) {
                this.resultFileWriter.append("false");
                this.resultFileWriter.append("OTHER_ERROR");
            }
            if (null != this.resultKeeper) {
                this.resultKeeper.addResult(HDIConstants.HDI_ENABLED, "false");
            }
        }
    }

    private boolean shouldCreateContainerGroup() {
        String containerGroupNameInHTA = null;
        if (null != this.resultKeeper) {
            containerGroupNameInHTA = this.resultKeeper.getResult(HDIConstants.CONTAINER_GROUP_NAME);
        }
        if (null != containerGroupNameInHTA && this.containerGroupExists(this.connection, this.systemUser, containerGroupNameInHTA)) {
            this.containerGroupName = containerGroupNameInHTA;
            return false;
        }
        return true;
    }

    private void createContainerGroup() {
        String containerGroupName;
        this.containerGroupName = containerGroupName = this.findUnusedContainerGroupName(this.databaseUser.getName().get());
        String sql = "CALL \"_SYS_DI\".\"CREATE_CONTAINER_GROUP\"('" + containerGroupName + "', _SYS_DI.T_NO_PARAMETERS, ?, ?, ?)";
        try {
            LogFactory.writeLogEntry(this.getClass(), "Run SQL command: " + sql);
            CallableStatement cs = this.connection.getConnection().prepareCall("{" + sql + "}");
            cs.registerOutParameter(1, -9);
            cs.execute();
            int rc = cs.getInt(1);
            ResultSet rs = cs.getResultSet();
            while (rs.next()) {
                LogFactory.writeLogEntry(this.getClass(), rs.getString("MESSAGE"));
            }
            if (rc < 0) {
                this.resultFileWriter.append("false");
                LogFactory.writeLogEntry(this.getClass(), "Could not create HDI container group " + containerGroupName);
                throw new HdbException("Could not create HDI container group " + containerGroupName);
            }
        }
        catch (SQLException e) {
            this.resultFileWriter.append("false");
            throw new HdbException("Could not create HDI container group " + containerGroupName);
        }
    }

    private String findUnusedContainerGroupName(String containerGroupName) {
        String containerGroupNameInHTA = null;
        if (null != this.resultKeeper) {
            containerGroupNameInHTA = this.resultKeeper.getResult(HDIConstants.CONTAINER_GROUP_NAME);
        }
        if (null != containerGroupNameInHTA && !this.containerGroupExists(this.connection, this.systemUser, containerGroupNameInHTA)) {
            return containerGroupNameInHTA;
        }
        if (this.containerGroupExists(this.connection, this.systemUser, containerGroupName)) {
            String hdiName = containerGroupName + "_HDI_";
            for (int i = 1; i < 20; ++i) {
                containerGroupName = hdiName + i;
                if (this.containerGroupExists(this.connection, this.systemUser, containerGroupName)) continue;
                return containerGroupName;
            }
        }
        return containerGroupName;
    }

    public boolean containerGroupExists(JdbcConnection connection, DatabaseSystemUser systemUser, String containerGroup) {
        boolean exist = false;
        connection.setConnectUser(systemUser);
        List<String> result = connection.executeSQLCommand("SELECT * FROM \"_SYS_DI\".\"M_ALL_CONTAINER_GROUPS\" WHERE CONTAINER_GROUP_NAME = '" + containerGroup + "'");
        if (result.size() == 1) {
            exist = true;
        }
        return exist;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

