/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.hdi.HDIHelper;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import com.sap.hdb.sl.lib.utils.HdbUserStore;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionResult;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterImpl;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.GetConnectHostsAndPorts;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class HDICreateSupportUser
extends BatchExecutionBase {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseSqlUser databaseUser = null;
    private DatabaseSystemUser systemUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    boolean create = true;
    boolean source = true;
    static String CONTAINER_SUPPORT_USER_NAME = "SUM_HDI_CONTAINER_SUPPORT_USER";

    protected HDICreateSupportUser() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.databaseUser = DatabaseSqlUserFactory.getUser(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        this.parameters = parameters;
    }

    @Override
    public void execute() {
        this.findOptions();
        this.connection.setConnectUser(this.databaseUser);
        String containerGroupName = HDIHelper.getContainerGroupName(this.connection, this.parameters);
        if (this.create) {
            if (null != containerGroupName) {
                List<String> containers = HDIHelper.getHdiContainers(this.connection, this.parameters);
                LogFactory.writeLogEntry(this.getClass(), "Create Support User and Grant Access to HDI Containers");
                this.createSupportUser();
                this.grantSupportUserPrivileges(this.connection);
                this.grantSupportUserAccess2Containers(this.connection, containers, containerGroupName);
                this.createUserStore();
            }
        } else {
            LogFactory.writeLogEntry(this.getClass(), "Drop Support User for HDI Containers");
            this.dropUser();
            this.dropUserStore();
        }
        if (null != this.resultFileWriter) {
            this.resultFileWriter.append("true");
        }
    }

    private void dropUserStore() {
        HdbUserStore.Key key = null;
        key = this.source ? HdbUserStore.Key.HDI_SUPPORT : HdbUserStore.Key.HDI_SUPPORT_TARGET;
        LogFactory.writeLogEntry(this.getClass(), "Drop userstore " + key.toString());
        CmdClazzParameterName userstoreKeyName = CmdClazzParameterName.USERSTORE_KEY_NAME;
        CmdClazzParameterImpl userstoreKeyValue = new CmdClazzParameterImpl(key.toString());
        this.parameters.put(userstoreKeyName, userstoreKeyValue);
        this.executeCmdClazz(CmdClazzName.DELETE_USERSTORE);
    }

    private void createUserStore() {
        this.resultKeeper = new BatchExecutionResult();
        this.executeCmdClazz(CmdClazzName.GET_CONNECT_HOSTS_AND_PORTS);
        String hostPortString = this.resultKeeper.getResult(GetConnectHostsAndPorts.CONNECT_HOSTS_AND_PORTS);
        if (hostPortString.length() == 0) {
            LogFactory.writeLogEntry(this.getClass(), "Could not find hostPortString string. Stop execution!");
            this.resultFileWriter.append("false");
            throw new HdbException("Could not find hostPortString. Stop execution!");
        }
        HdbUserStore.Key key = null;
        key = this.source ? HdbUserStore.Key.HDI_SUPPORT : HdbUserStore.Key.HDI_SUPPORT_TARGET;
        LogFactory.writeLogEntry(this.getClass(), "Create userstore " + key.toString());
        CmdClazzParameterName userstoreKeyName = CmdClazzParameterName.USERSTORE_KEY_NAME;
        CmdClazzParameterImpl userstoreKeyValue = new CmdClazzParameterImpl(key.toString());
        this.parameters.put(userstoreKeyName, userstoreKeyValue);
        this.parameters.put(CmdClazzParameterName.DATABASE_SQL_USER_NAME, new DatabaseSqlUserName(CONTAINER_SUPPORT_USER_NAME));
        this.parameters.put(CmdClazzParameterName.USERSTORE_ENV, new CmdClazzParameterImpl(hostPortString));
        this.executeCmdClazz(CmdClazzName.CREATE_USERSTORE);
    }

    private void createSupportUser() {
        CmdClazzParameter sqlUserName = this.parameters.get(CmdClazzParameterName.DATABASE_SQL_USER_NAME);
        this.parameters.put(CmdClazzParameterName.DATABASE_SQL_USER_NAME, new DatabaseSqlUserName(CONTAINER_SUPPORT_USER_NAME));
        this.executeCmdClazz(CmdClazzName.CREATE_DATABASE_SHADOW_USER);
        this.parameters.put(CmdClazzParameterName.DATABASE_SQL_USER_NAME, sqlUserName);
    }

    private void dropUser() {
        try {
            String dropSupportUser = "DROP USER " + CONTAINER_SUPPORT_USER_NAME + " CASCADE";
            this.connection.setConnectUser(this.systemUser);
            this.connection.executeSQLCommand(dropSupportUser);
        }
        catch (HdbException e) {
            if (e.getMessage().contains("[332]")) {
                LogFactory.writeLogEntry(HDICreateSupportUser.class, "User " + CONTAINER_SUPPORT_USER_NAME + " doesn't exist. Continue.");
            }
            throw e;
        }
    }

    private void grantSupportUserPrivileges(JdbcConnection connection) {
        String[] privileges = new String[]{"INIFILE ADMIN"};
        String grantPrivSql = "GRANT <PRIVILEGE> TO " + CONTAINER_SUPPORT_USER_NAME;
        for (String privilege : privileges) {
            String sql = grantPrivSql.replace("<PRIVILEGE>", privilege);
            connection.executeSQLCommandNoReslt(sql);
        }
    }

    private List<String> grantSupportUserAccess2Containers(JdbcConnection connection, List<String> containers, String containerGroupName) {
        ArrayList<String> failedContainers = new ArrayList<String>();
        for (String container : containers) {
            try {
                this.grantSupportUserAccessToContainer(connection, container, containerGroupName);
            }
            catch (Exception e) {
                failedContainers.add(container);
            }
        }
        if (failedContainers.size() > 0) {
            LogFactory.writeLogEntry(HDICreateSupportUser.class, "Could not grant support access to HDI containers: " + failedContainers);
        }
        return failedContainers;
    }

    private void grantSupportUserAccessToContainer(JdbcConnection connection, String containerName, String containerGroupName) {
        String grantContainerSupportSql = "CALL _SYS_DI#<CONTAINER_GROUP_NAME>.GRANT_CONTAINER_SUPPORT_PRIVILEGE('<CONTAINER>', '<PRIVILEGE>', '" + CONTAINER_SUPPORT_USER_NAME + "', _SYS_DI.T_NO_PARAMETERS, ?, ?, ?)";
        String[] privileges = new String[]{"SELECT", "INSERT", "UPDATE", "DELETE"};
        grantContainerSupportSql = grantContainerSupportSql.replace("<CONTAINER>", containerName);
        grantContainerSupportSql = grantContainerSupportSql.replace("<CONTAINER_GROUP_NAME>", containerGroupName);
        connection.setConnectUser(this.databaseUser);
        try {
            for (String privilege : privileges) {
                String sql = grantContainerSupportSql.replace("<PRIVILEGE>", privilege);
                LogFactory.writeLogEntry(HDICreateSupportUser.class, "Run SQL command: " + sql);
                CallableStatement cs = connection.getConnection().prepareCall("{" + sql + "}");
                cs.registerOutParameter(1, -9);
                cs.execute();
                int rc = cs.getInt(1);
                if (rc >= 0) continue;
                LogFactory.writeLogEntry(this.getClass(), "Could not grant support user " + CONTAINER_SUPPORT_USER_NAME + " privileges for HDI container " + containerName + " . rc=" + rc);
                throw new HdbException("Could not grant support user " + CONTAINER_SUPPORT_USER_NAME + " privileges for HDI container " + containerName);
            }
        }
        catch (SQLException e) {
            throw new HdbException("Could not grant support user " + CONTAINER_SUPPORT_USER_NAME + " privileges for HDI container " + containerName);
        }
    }

    private void findOptions() {
        String[] options = this.parameters.getOptions();
        if (null != options && options.length > 0) {
            for (String option : options) {
                if (option.equalsIgnoreCase("DROP")) {
                    this.create = false;
                    continue;
                }
                if (!option.equalsIgnoreCase("TARGET")) continue;
                this.source = false;
            }
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

