/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class HDIDropContainerGroup
extends BatchExecutionBase {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private DatabaseSqlUser databaseUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private String containerGroupName = null;

    protected HDIDropContainerGroup() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.databaseUser = DatabaseSqlUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        if (parameters.containsKey(CmdClazzParameterName.HDI_CONTAINER_GROUP_NAME)) {
            this.containerGroupName = parameters.get(CmdClazzParameterName.HDI_CONTAINER_GROUP_NAME).getValue();
        }
    }

    @Override
    public void execute() {
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        if (null == this.containerGroupName) {
            this.connection.setConnectUser(this.databaseUser);
            if (this.tableExists("CTS_HOT_CONFIG")) {
                this.containerGroupName = this.getContainerFromHtaTable();
            }
            if (null == this.containerGroupName) {
                LogFactory.writeLogEntry(this.getClass(), "Could not find HDI container group for user " + this.databaseUser.getName().get());
                return;
            }
        }
        this.connection.setConnectUser(this.systemUser);
        if (this.containerGroupExists(this.connection, this.systemUser, this.containerGroupName)) {
            if (0 == this.deleteContainerGroup(this.connection, this.systemUser, this.databaseUser, this.containerGroupName)) {
                if (null != this.resultFileWriter) {
                    this.resultFileWriter.append("true");
                }
                LogFactory.writeLogEntry(this.getClass(), "HDI container group " + this.containerGroupName + " dropped successfully.");
            } else {
                if (null != this.resultFileWriter) {
                    this.resultFileWriter.append("false");
                }
                LogFactory.writeLogEntry(this.getClass(), "Could not drop HDI container group " + this.containerGroupName);
            }
        } else {
            if (null != this.resultFileWriter) {
                this.resultFileWriter.append("true");
            }
            LogFactory.writeLogEntry(this.getClass(), "HDI container group " + this.containerGroupName + " does not exist.");
        }
    }

    private String getContainerFromHtaTable() {
        List<String> result = this.connection.executeSQLCommand("SELECT VALUE from CTS_HOT_CONFIG WHERE NAME = 'HDI_CONTAINER_GROUP'");
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    private boolean tableExists(String tableName) {
        List<String> result = this.connection.executeSQLCommand("SELECT COUNT(*) FROM TABLES WHERE TABLE_NAME = '" + tableName + "' AND SCHEMA_NAME = CURRENT_USER");
        return result.get(0).equals("1");
    }

    private int deleteContainerGroup(JdbcConnection connection, DatabaseSystemUser systemUser, DatabaseSqlUser databaseUser, String containerGroup) {
        List<String> containers = this.findAllContainers(connection);
        int rc = this.dropContainers(connection, containers);
        return rc += this.dropContainerGroup(connection);
    }

    private int dropContainerGroup(JdbcConnection connection) {
        int rc;
        String sql = "CALL \"_SYS_DI\".\"DROP_CONTAINER_GROUP\"('<group name>', _SYS_DI.T_NO_PARAMETERS, ?, ?, ?)";
        sql = sql.replace("<group name>", this.containerGroupName);
        connection.setConnectUser(this.systemUser);
        try {
            CallableStatement cs = connection.getConnection().prepareCall("{" + sql + "}");
            cs.registerOutParameter(1, -9);
            cs.execute();
            rc = cs.getInt(1);
        }
        catch (SQLException e) {
            throw new HdbException(e);
        }
        return rc;
    }

    private int dropContainers(JdbcConnection connection, List<String> containers) {
        int rc = 0;
        connection.setConnectUser(this.databaseUser);
        connection.executeSQLCommand("CREATE LOCAL TEMPORARY COLUMN TABLE #DROPPARAMETERS LIKE _SYS_DI.TT_PARAMETERS");
        connection.executeSQLCommand("INSERT INTO #DROPPARAMETERS (\"KEY\", \"VALUE\") VALUES ('ignore_work', 'true')");
        connection.executeSQLCommand("INSERT INTO #DROPPARAMETERS (\"KEY\", \"VALUE\") VALUES ('ignore_deployed', 'true')");
        for (String container : containers) {
            String sql = "CALL _SYS_DI#<group name>.DROP_CONTAINER('<container name>', #DROPPARAMETERS, ?, ?, ?)";
            sql = sql.replace("<group name>", this.containerGroupName);
            sql = sql.replace("<container name>", container);
            try {
                CallableStatement cs = connection.getConnection().prepareCall("{" + sql + "}");
                cs.registerOutParameter(1, -9);
                cs.execute();
                LogFactory.writeLogEntry(this.getClass(), "Result from " + sql + " -> " + (rc += cs.getInt(1)));
            }
            catch (SQLException e) {
                throw new HdbException(e);
            }
        }
        return rc;
    }

    private List<String> findAllContainers(JdbcConnection connection) {
        String findAllContainerSql = "SELECT CONTAINER_NAME FROM _SYS_DI.M_ALL_CONTAINERS WHERE CONTAINER_GROUP_NAME='<group name>'";
        findAllContainerSql = findAllContainerSql.replace("<group name>", this.containerGroupName);
        ArrayList<String> containers = new ArrayList<String>();
        connection.setConnectUser(this.systemUser);
        List<String> result = connection.executeSQLCommand(findAllContainerSql);
        for (String container : result) {
            containers.add(container);
        }
        return containers;
    }

    public boolean containerGroupExists(JdbcConnection connection, DatabaseSystemUser systemUser, String containerGroup) {
        boolean exist = false;
        connection.setConnectUser(systemUser);
        List<String> result = connection.executeSQLCommand("SELECT * FROM \"_SYS_DI\".\"M_ALL_CONTAINER_GROUPS\" WHERE CONTAINER_GROUP_NAME = '" + containerGroup + "'");
        if (result.size() == 1) {
            exist = true;
        }
        return exist;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

