/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.List;

public class HDIExist
implements CmdClazz {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private DatabaseSqlUser databaseUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;

    protected HDIExist() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.databaseUser = DatabaseSqlUserFactory.getUser(parameters);
        if (parameters.containsKey(CmdClazzParameterName.DATABASE_SYSTEM_USER_PASSWORD)) {
            this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        }
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        boolean hdiExist = false;
        hdiExist = this.databaseUser.getPassword() != null ? this.doesHDIExistAbap() : this.doesHDIExistSystem();
        this.resultFileWriter.append(String.valueOf(hdiExist));
    }

    private boolean doesHDIExistSystem() {
        String sql = "SELECT SCHEMA_NAME FROM SYS.GRANTED_PRIVILEGES WHERE GRANTEE = '<SAPSID>' AND GRANTOR = '_SYS_DI' AND OBJECT_TYPE = 'SCHEMA' AND SCHEMA_NAME LIKE '_SYS_DI#%'";
        sql = sql.replace("<SAPSID>", this.databaseUser.getName().get());
        this.connection.setConnectUser(this.systemUser);
        List<String> result = this.connection.executeSQLCommand(sql);
        return result.size() > 0;
    }

    private boolean doesHDIExistAbap() {
        String containerName = null;
        this.connection.setConnectUser(this.databaseUser);
        if (this.tableExists("CTS_HOT_CONFIG")) {
            containerName = this.getContainerFromHtaTable();
        }
        return null != containerName;
    }

    private String getContainerFromHtaTable() {
        List<String> result = this.connection.executeSQLCommand("SELECT VALUE from CTS_HOT_CONFIG WHERE NAME = 'HDI_CONTAINER_GROUP'");
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    private boolean tableExists(String tableName) {
        List<String> result = this.connection.executeSQLCommand("SELECT COUNT(*) FROM TABLES WHERE TABLE_NAME = '" + tableName + "' AND SCHEMA_NAME = CURRENT_USER");
        return result.get(0).equals("1");
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

