/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.HdbConnection;
import com.sap.hdb.sl.lib.connection.sql.HdbsqlConnection;
import com.sap.hdb.sl.lib.connection.sql.HdbsqlExecutable;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.hdi.GrantHDIPrivilegesShadowSQLs;
import com.sap.hdb.sl.lib.hdi.HdiData;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseHdbsqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.io.IOException;
import java.util.LinkedList;

public class HDIGrantPrivilegesShadow
implements CmdClazz {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseSqlUser sqlUser = null;
    private JdbcDriver jdbcDriver = null;
    HdbConnection slConnection = null;
    HdiData hdiData = null;

    protected HDIGrantPrivilegesShadow() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        this.hdiData = new HdiData(parameters);
        if (this.sqlUser.useJdbc()) {
            this.database = InstanceFactory.getDatabaseInstance(parameters);
            this.jdbcDriver = new JdbcDriver(parameters);
        }
    }

    @Override
    public void execute() {
        if (this.sqlUser.useJdbc()) {
            this.slConnection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
            this.slConnection.setConnectUser(this.sqlUser);
            this.hdiData.setShadowUserName(this.sqlUser.getName().get() + "SHD");
        } else {
            this.slConnection = new HdbsqlConnection();
            DatabaseHdbsqlUser hdbSqlUser = (DatabaseHdbsqlUser)this.sqlUser;
            this.slConnection.setConnectUser(hdbSqlUser);
            HdbsqlExecutable hdbsqlExec = new HdbsqlExecutable();
            DatabaseHdbsqlUser shadowUser = new DatabaseHdbsqlUser("UPGSHDKEY", hdbsqlExec);
            this.hdiData.setShadowUserName(shadowUser.getName().get());
            try {
                GrantHDIPrivilegesShadowSQLs.prepareSQL(this.hdiData);
            }
            catch (IOException e) {
                LogFactory.writeLogExceptionEntry(this.getClass(), e.getMessage(), "Could not write sqls to file " + this.hdiData.getSqlFile());
                throw new HdbException(e.getMessage());
            }
        }
        if (0 == this.grantPrivileges()) {
            this.resultFileWriter.append("true");
        } else {
            this.resultFileWriter.append("false");
        }
    }

    private int grantPrivileges() {
        if (this.slConnection instanceof HdbsqlConnection) {
            HdbsqlConnection hdbsqlConn = (HdbsqlConnection)this.slConnection;
            hdbsqlConn.executeWithFile(this.hdiData.getSqlFile());
            return 0;
        }
        this.grantPrivilegesJdbc();
        return 0;
    }

    private int grantPrivilegesJdbc() {
        try {
            this.slConnection.executeSQLCommand("DROP TABLE #PRIVILEGES", true);
            this.slConnection.executeSQLCommand("CREATE LOCAL TEMPORARY TABLE #PRIVILEGES LIKE _SYS_DI.TT_API_PRIVILEGES");
            this.slConnection.executeSQLCommand("INSERT INTO #PRIVILEGES (PRINCIPAL_NAME, PRIVILEGE_NAME, OBJECT_NAME) SELECT '" + this.hdiData.getShadowUserName() + "', PRIVILEGE_NAME, OBJECT_NAME FROM _SYS_DI.T_DEFAULT_CONTAINER_GROUP_ADMIN_PRIVILEGES");
            this.slConnection.executeSQLCommand("{CALL _SYS_DI#" + this.hdiData.getContainerGroupName() + ".GRANT_CONTAINER_GROUP_API_PRIVILEGES( #PRIVILEGES, _SYS_DI.T_NO_PARAMETERS, ?, ?, NULL )}");
            this.slConnection.executeSQLCommand("TRUNCATE TABLE #PRIVILEGES");
            this.slConnection.executeSQLCommand("INSERT INTO #PRIVILEGES ( PRINCIPAL_NAME, PRIVILEGE_NAME, OBJECT_NAME ) SELECT '" + this.hdiData.getShadowUserName() + "', PRIVILEGE_NAME, OBJECT_NAME FROM _SYS_DI.T_DEFAULT_CONTAINER_USER_PRIVILEGES");
            LinkedList<String> apiContainers = this.hdiData.getHdiContainersData();
            for (String container : apiContainers) {
                this.slConnection.executeSQLCommand("{CALL _SYS_DI#" + this.hdiData.getContainerGroupName() + ".GRANT_CONTAINER_API_PRIVILEGES( '" + container + "', #PRIVILEGES, _SYS_DI.T_NO_PARAMETERS, ?, ?, NULL ) }");
            }
            apiContainers = this.hdiData.getHdiContainersApi();
            for (String container : apiContainers) {
                this.slConnection.executeSQLCommand("{CALL _SYS_DI#" + this.hdiData.getContainerGroupName() + ".GRANT_CONTAINER_API_PRIVILEGES( '" + container + "', #PRIVILEGES, _SYS_DI.T_NO_PARAMETERS, ?, ?, NULL ) }");
            }
            this.slConnection.executeSQLCommand("DROP TABLE #PRIVILEGES");
            this.slConnection.executeSQLCommand("GRANT DELETE ON _SYS_BI.BIMC_DESCRIPTIONS TO " + this.hdiData.getShadowUserName());
            this.slConnection.executeSQLCommand("GRANT INSERT ON _SYS_BI.BIMC_DESCRIPTIONS TO " + this.hdiData.getShadowUserName());
            this.slConnection.executeSQLCommand("GRANT UPDATE ON _SYS_BI.BIMC_DESCRIPTIONS TO " + this.hdiData.getShadowUserName());
            this.slConnection.executeSQLCommand("GRANT SELECT ON _SYS_BI.BIMC_DESCRIPTIONS TO " + this.hdiData.getShadowUserName());
        }
        catch (HdbException e) {
            String message = e.getMessage();
            if (message.contains("invalid table name") && message.contains("T_DEFAULT_CONTAINER_GROUP_ADMIN_PRIVILEGES")) {
                LogFactory.writeLogEntry(this.getClass(), "Could not grant privileges via T_DEFAULT_CONTAINER_GROUP_ADMIN_PRIVILEGES, fallin' back to the old way not yet implemented. Solution is to update HANA.");
            }
            throw e;
        }
        return 0;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

