/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.hdi.HDIHelper;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.HDIMigrate;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class HDILock
extends BatchExecutionBase {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseSqlUser databaseUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    boolean lock = true;
    String createPrivs = "CREATE LOCAL TEMPORARY COLUMN TABLE #PRIVILEGES LIKE _SYS_DI.TT_API_PRIVILEGES";
    String dropPrivs = "DROP TABLE #PRIVILEGES";

    protected HDILock() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.databaseUser = DatabaseSqlUserFactory.getUser(parameters);
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        this.parameters = parameters;
    }

    @Override
    public void execute() {
        this.findOptions();
        this.connection.setConnectUser(this.databaseUser);
        String containerGroupName = HDIHelper.getContainerGroupName(this.connection, this.parameters);
        if (null != containerGroupName) {
            List<String> containers = HDIHelper.getHdiContainers(this.connection, this.parameters);
            if (this.lock) {
                LogFactory.writeLogEntry(this.getClass(), "Start LOCK HDI Containers on SOURCE");
                this.lockContainers(this.connection, containers, containerGroupName);
            } else {
                LogFactory.writeLogEntry(this.getClass(), "Start UNLOCK HDI Containers on SOURCE");
                this.unlockContainers(this.connection, containers, containerGroupName);
            }
        }
        if (null != this.resultFileWriter) {
            this.resultFileWriter.append("true");
        }
    }

    private List<String> unlockContainers(JdbcConnection connection, List<String> containers, String containerGroupName) {
        ArrayList<String> failedContainers = new ArrayList<String>();
        for (String container : containers) {
            try {
                this.unlockContainer(connection, container, containerGroupName);
            }
            catch (Exception e) {
                failedContainers.add(container);
            }
        }
        if (failedContainers.size() > 0) {
            LogFactory.writeLogEntry(HDILock.class, "Could not lock HDI containers: " + failedContainers);
        }
        return failedContainers;
    }

    private List<String> lockContainers(JdbcConnection connection, List<String> containers, String containerGroupName) {
        ArrayList<String> failedContainers = new ArrayList<String>();
        for (String container : containers) {
            try {
                this.lockContainer(connection, container, containerGroupName);
            }
            catch (Exception e) {
                failedContainers.add(container);
            }
        }
        if (failedContainers.size() > 0) {
            LogFactory.writeLogEntry(HDILock.class, "Could not lock HDI containers: " + failedContainers);
        }
        return failedContainers;
    }

    private void lockContainer(JdbcConnection connection, String containerName, String containerGroupName) {
        String insertInPrivMake = "INSERT INTO #PRIVILEGES (PRINCIPAL_NAME, PRIVILEGE_NAME, OBJECT_NAME) VALUES ('" + this.databaseUser.getName().get() + "', 'EXECUTE', 'MAKE')";
        String insertInPrivWrite = "INSERT INTO #PRIVILEGES (PRINCIPAL_NAME, PRIVILEGE_NAME, OBJECT_NAME) VALUES ('" + this.databaseUser.getName().get() + "', 'EXECUTE', 'WRITE')";
        String revokeSqlSql = "CALL _SYS_DI#<CONTAINER_GROUP_NAME>.REVOKE_CONTAINER_API_PRIVILEGES('<CONTAINER>', #PRIVILEGES, _SYS_DI.T_NO_PARAMETERS, ?, ?, ?)";
        revokeSqlSql = revokeSqlSql.replace("<CONTAINER>", containerName);
        revokeSqlSql = revokeSqlSql.replace("<CONTAINER_GROUP_NAME>", containerGroupName);
        try {
            connection.executeSQLCommand(this.createPrivs);
            connection.executeSQLCommand(insertInPrivMake);
            connection.executeSQLCommand(insertInPrivWrite);
            LogFactory.writeLogEntry(HDIMigrate.class, "Run SQL command: " + revokeSqlSql);
            CallableStatement cs = connection.getConnection().prepareCall("{" + revokeSqlSql + "}");
            cs.registerOutParameter(1, -9);
            cs.execute();
            int rc = cs.getInt(1);
            ResultSet rs = cs.getResultSet();
            while (rs.next()) {
                LogFactory.writeLogEntry(this.getClass(), rs.getString("MESSAGE"));
            }
            connection.executeSQLCommand(this.dropPrivs);
            if (rc < 0) {
                LogFactory.writeLogEntry(this.getClass(), "Could not revoke MAKE privileges for HDI container " + containerName + " from ABAP schema User. rc=" + rc);
                throw new HdbException("Could not revoke MAKE privileges for HDI container " + containerName + " from ABAP schema User.");
            }
        }
        catch (SQLException e) {
            connection.executeSQLCommand(this.dropPrivs);
            throw new HdbException("Could not revoke MAKE privileges for HDI container " + containerName + " from ABAP schema User.");
        }
    }

    private void unlockContainer(JdbcConnection connection, String containerName, String containerGroupName) {
        String insertInPrivMake = "INSERT INTO #PRIVILEGES (PRINCIPAL_NAME, PRIVILEGE_NAME, OBJECT_NAME) VALUES ('" + this.databaseUser.getName().get() + "', 'EXECUTE', 'MAKE')";
        String insertInPrivWrite = "INSERT INTO #PRIVILEGES (PRINCIPAL_NAME, PRIVILEGE_NAME, OBJECT_NAME) VALUES ('" + this.databaseUser.getName().get() + "', 'EXECUTE', 'WRITE')";
        String revokeSqlSql = "CALL _SYS_DI#<CONTAINER_GROUP_NAME>.GRANT_CONTAINER_API_PRIVILEGES('<CONTAINER>', #PRIVILEGES, _SYS_DI.T_NO_PARAMETERS, ?, ?, ?)";
        revokeSqlSql = revokeSqlSql.replace("<CONTAINER>", containerName);
        revokeSqlSql = revokeSqlSql.replace("<CONTAINER_GROUP_NAME>", containerGroupName);
        try {
            connection.executeSQLCommand(this.createPrivs);
            connection.executeSQLCommand(insertInPrivMake);
            connection.executeSQLCommand(insertInPrivWrite);
            LogFactory.writeLogEntry(HDIMigrate.class, "Run SQL command: " + revokeSqlSql);
            CallableStatement cs = connection.getConnection().prepareCall("{" + revokeSqlSql + "}");
            cs.registerOutParameter(1, -9);
            cs.execute();
            int rc = cs.getInt(1);
            ResultSet rs = cs.getResultSet();
            while (rs.next()) {
                LogFactory.writeLogEntry(this.getClass(), rs.getString("MESSAGE"));
            }
            connection.executeSQLCommand(this.dropPrivs);
            if (rc < 0) {
                LogFactory.writeLogEntry(this.getClass(), "Could not grant MAKE privileges for HDI container " + containerName + " to ABAP schema User. rc=" + rc);
                throw new HdbException("Could not grant MAKE privileges for HDI container " + containerName + " to ABAP schema User.");
            }
        }
        catch (SQLException e) {
            connection.executeSQLCommand(this.dropPrivs);
            throw new HdbException("Could not grant MAKE privileges for HDI container " + containerName + " to ABAP schema User.");
        }
    }

    private void findOptions() {
        String[] options = this.parameters.getOptions();
        if (null != options && options.length > 0) {
            for (String option : options) {
                if (!option.equalsIgnoreCase("UNLOCK")) continue;
                this.lock = false;
            }
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

