/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.abap.BasisUtils;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.hdi.HDIConstants;
import com.sap.hdb.sl.lib.hdi.HDIHelper;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.mem.HdbsllibMem;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.IOUtils;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionResult;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.UpdateRepairRolesAndPrivileges;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HDIMigrate
extends BatchExecutionBase {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseSqlUser databaseUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private DatabaseSystemUser systemUser = null;
    File containerInfoFile = null;
    File containerRefFile = null;
    File containerLogicalPhysicalFile = null;
    protected BufferedReader reader = null;
    protected PrintWriter writer = null;
    boolean source = true;
    Map<String, String> logicalPhysicalContainers = new HashMap<String, String>();
    Map<String, String> physicalLogicalContainers = new HashMap<String, String>();
    Map<String, List<CTS_AMHC_REF_Entry>> logicalContainersRefs = new HashMap<String, List<CTS_AMHC_REF_Entry>>();
    static String SUM_HDI_DEPLOYED = "SUM_HDI_DEPLOYED";
    String SAP_ABAP = "SAP_ABAP";
    String REF_TYPE_C = "C";

    protected HDIMigrate() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        this.databaseUser = DatabaseSqlUserFactory.getUser(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.setContainerInfoFile(parameters);
        this.setContainerRefFile();
        this.setContainerLogicalPhysicaFile();
        this.parameters = parameters;
        this.findOptions();
    }

    @Override
    public void execute() {
        if (this.source) {
            LogFactory.writeLogEntry(this.getClass(), "Start HDI Migration on SOURCE");
            this.executeOnSource();
        } else {
            LogFactory.writeLogEntry(this.getClass(), "Start HDI Migration on TARGET");
            this.executeOnTarget();
        }
        this.resultFileWriter.append("true");
    }

    private void executeOnSource() {
        this.createContainerInfoFile();
        String sap_basis = HDIHelper.checkCVERSBasis(this.connection, this.databaseUser);
        if (!HDIHelper.sapBasisNeedsHdi(sap_basis)) {
            return;
        }
        String containerGroupName = HDIHelper.findContainerGroupNameFromHtaTable(this.connection);
        if (null != containerGroupName) {
            this.connection.setConnectUser(this.databaseUser);
            this.executeCmdClazz(CmdClazzName.HDI_LOCK);
            this.writeContainerGroupName(containerGroupName);
            this.connection.setConnectUser(this.databaseUser);
            List<String> containers = HDIHelper.readContainersFromHTA(this.connection);
            this.fillLogicalPhysicalContainerMapOnSource(this.connection, containerGroupName, containers);
            this.fillLogicalContainersRefsOnSource(this.connection, containerGroupName, containers);
            this.checkTable_SUM_HDI_DEPLOYED();
            List<String> failedContainers = new ArrayList<String>();
            failedContainers = this.readDeployedOnSourceContainers(this.connection, containers, failedContainers);
            if (failedContainers.size() > 0) {
                this.resultFileWriter.append("false");
                if (failedContainers.size() > 0) {
                    String message = "Could not read deployed on source for HDI containers: ";
                    for (String containerName : failedContainers) {
                        message = message + " | " + containerName;
                    }
                    LogFactory.writeLogEntry(this.getClass(), message);
                    throw new HdbException(message);
                }
            }
        }
    }

    private void writeContainerGroupName(String containerGroupName) {
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(this.containerInfoFile, false));
            pw.println("HDI_CONTAINER_GROUP=" + containerGroupName);
            pw.flush();
            pw.close();
        }
        catch (IOException e) {
            throw new HdbException("PrintWriter for " + this.containerInfoFile + " could not be created!");
        }
    }

    private List<String> readDeployedOnSourceContainers(JdbcConnection connection, List<String> containers, List<String> failedContainers) {
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(this.containerInfoFile, true));
            for (String container : containers) {
                try {
                    long start = System.currentTimeMillis();
                    this.readDeployedOnSource(container);
                    long finish = System.currentTimeMillis();
                    long timeElapsed = finish - start;
                    if (timeElapsed > 2000L) {
                        LogFactory.writeLogEntry(HDIHelper.class, "Time for readDeployedOnSource for " + container + " container: " + (int)timeElapsed / 1000 + " seconds");
                    }
                    pw.println(container);
                    pw.flush();
                }
                catch (Exception e) {
                    LogFactory.writeLogEntry(this.getClass(), "Could not read deployed on source for HDI container: " + container);
                    failedContainers.add(container);
                }
            }
            pw.close();
        }
        catch (IOException e) {
            throw new HdbException("PrintWriter for " + this.containerInfoFile + " could not be created!");
        }
        return failedContainers;
    }

    private void readDeployedOnSource(String physicalContainerName) {
        String logicalContainerName = this.physicalLogicalContainers.get(physicalContainerName);
        int number = 0;
        this.connection.setConnectUser(this.databaseUser);
        String parameters = "CREATE LOCAL TEMPORARY COLUMN TABLE #PARAMETERS LIKE _SYS_DI.TT_PARAMETERS";
        String insertInParameters = "INSERT INTO #PARAMETERS ( KEY, VALUE ) VALUES ('recursive', 'true')";
        String dropParameters = "DROP TABLE #PARAMETERS";
        try {
            this.connection.executeSQLCommand(parameters);
            this.connection.executeSQLCommand(insertInParameters);
            String callProcedure = "CALL " + physicalContainerName + "#DI.READ_DEPLOYED(_SYS_DI.T_NO_FILESFOLDERS, #PARAMETERS, ?, ?, ?, ?)";
            LogFactory.writeLogEntry(HDIMigrate.class, "Run SQL command: " + callProcedure);
            CallableStatement cs = this.connection.getConnection().prepareCall("{" + callProcedure + "}");
            cs.execute();
            cs.getMoreResults();
            int rc = cs.getInt(1);
            LogFactory.writeLogEntry(HDIMigrate.class, "SQL command: " + callProcedure + " end with rc=" + rc);
            ResultSet resultSet = cs.getResultSet();
            String insertStmt = "INSERT INTO " + SUM_HDI_DEPLOYED + " (LOGICAL_CONTAINER_NAME, PATH_NUMBER, PATH, PHYSICAL_CONTAINER_NAME, CONTENT) VALUES (?, ?, ?, ?, ?)";
            PreparedStatement prepStmt = this.connection.getConnection().prepareStatement(insertStmt);
            int batchSize = 100;
            int batchCount = 0;
            LogFactory.writeLogEntry(HDIMigrate.class, "Run SQL command: " + insertStmt);
            while (resultSet.next()) {
                String path = resultSet.getString("PATH");
                Blob content = resultSet.getBlob("CONTENT");
                prepStmt.setString(1, logicalContainerName);
                prepStmt.setInt(2, number++);
                prepStmt.setString(3, path);
                prepStmt.setString(4, physicalContainerName);
                prepStmt.setBlob(5, content);
                prepStmt.addBatch();
                if (++batchCount % batchSize != 0) continue;
                prepStmt.executeBatch();
                batchCount = 0;
            }
            prepStmt.executeBatch();
            this.connection.executeSQLCommand(dropParameters);
        }
        catch (SQLException e) {
            this.connection.executeSQLCommand(dropParameters);
            throw new HdbException(e);
        }
    }

    private void checkTable_SUM_HDI_DEPLOYED() {
        this.connection.setConnectUser(this.databaseUser);
        if (!this.SUM_HDI_DEPLOYED_Exists()) {
            LogFactory.writeLogEntry(HDIMigrate.class, "Table for " + SUM_HDI_DEPLOYED + " doesn't exist. Will create it.");
            String createSql = "CREATE TABLE " + this.databaseUser.getName().get() + "." + SUM_HDI_DEPLOYED + " ( \"LOGICAL_CONTAINER_NAME\" NVARCHAR(30) DEFAULT '' NOT NULL ," + " \"PATH_NUMBER\" INTEGER," + " \"PATH\" NVARCHAR(512) CS_STRING," + " \"PHYSICAL_CONTAINER_NAME\" NVARCHAR(256) DEFAULT '' NOT NULL," + " \"CONTENT\" BLOB MEMORY THRESHOLD 1000, CONSTRAINT \"HDI_READ_DEPLOYED~0\"" + " PRIMARY KEY (\"LOGICAL_CONTAINER_NAME\", \"PATH_NUMBER\"))";
            this.connection.executeSQLCommandNoReslt(createSql);
        }
        this.truncateTable(SUM_HDI_DEPLOYED);
    }

    private boolean SUM_HDI_DEPLOYED_Exists() {
        this.connection.setConnectUser(this.databaseUser);
        String sql = "select COUNT(*) from SYS.TABLES where TABLE_NAME = '" + SUM_HDI_DEPLOYED + "' and SCHEMA_NAME = CURRENT_SCHEMA";
        List<String> result = this.connection.executeSQLCommand(sql);
        return result.get(0).equals("1");
    }

    private boolean SUM_HDI_DEPLOYED_Empty() {
        this.connection.setConnectUser(this.databaseUser);
        String sql = "select COUNT(*) from " + SUM_HDI_DEPLOYED;
        List<String> result = this.connection.executeSQLCommand(sql);
        return result.get(0).equals("0");
    }

    private void truncateTable(String tableName) {
        String sql = "TRUNCATE TABLE " + this.databaseUser.getName().get() + "." + tableName;
        this.connection.executeSQLCommandNoReslt(sql);
    }

    private void executeOnTarget() {
        if (!this.SUM_HDI_DEPLOYED_Exists()) {
            LogFactory.writeLogEntry(HDIMigrate.class, "Table " + SUM_HDI_DEPLOYED + " does not exist. Nothing to do.");
            return;
        }
        if (this.SUM_HDI_DEPLOYED_Empty()) {
            LogFactory.writeLogEntry(HDIMigrate.class, "Table " + SUM_HDI_DEPLOYED + " empty. Nothing to do.");
            return;
        }
        this.resultKeeper = new BatchExecutionResult();
        int cvers_basis = BasisUtils.checkCVERSBasisRelease(this.connection, this.databaseUser);
        String CONTAINER_GROUP_NAME = HDIHelper.getContainerGroupFromContainerInfoFile(this.containerInfoFile);
        if (!HDIHelper.sapBasisNeedsHdi(cvers_basis) || null == CONTAINER_GROUP_NAME) {
            LogFactory.writeLogEntry(HDIMigrate.class, HDIConstants.SAP_BASIS + "=" + cvers_basis);
            LogFactory.writeLogEntry(HDIMigrate.class, HDIConstants.CONTAINER_GROUP_NAME + "=" + CONTAINER_GROUP_NAME + " Nothing to do.");
            return;
        }
        this.resultKeeper.addResult(HDIConstants.CONTAINER_GROUP_NAME, CONTAINER_GROUP_NAME);
        this.executeCmdClazz(CmdClazzName.CREATE_HDI_CONTAINER_GROUP_ADD_PRIVILEGES);
        String DISERVER_IS_ACTIVE = this.resultKeeper.getResult(HDIConstants.DISERVER_IS_ACTIVE);
        LogFactory.writeLogEntry(HDIMigrate.class, HDIConstants.HDI_ENABLED + "=" + this.resultKeeper.getResult(HDIConstants.HDI_ENABLED));
        LogFactory.writeLogEntry(HDIMigrate.class, HDIConstants.CONTAINER_GROUP_NAME + "=" + this.resultKeeper.getResult(HDIConstants.CONTAINER_GROUP_NAME));
        LogFactory.writeLogEntry(HDIMigrate.class, HDIConstants.DISERVER_IS_ACTIVE + "=" + DISERVER_IS_ACTIVE);
        LogFactory.writeLogEntry(HDIMigrate.class, HDIConstants.SAP_BASIS + "=" + cvers_basis);
        if (!DISERVER_IS_ACTIVE.equalsIgnoreCase("true")) {
            this.resultFileWriter.append("false");
            throw new HdbException("Could not execute HDI Migrate on TARGET. Reason - diserver is not active.");
        }
        List<String> containers = HDIHelper.getContainersFromContainerInfoFile(this.containerInfoFile);
        List<String> failedContainers = new ArrayList<String>();
        this.connection.setConnectUser(this.databaseUser);
        this.fillLogicalPhysicalContainerMapOnTarget();
        this.fillLogicalContainersRefsOnTarget();
        failedContainers = this.repeatCreateDeployContainers(this.connection, CONTAINER_GROUP_NAME, containers, failedContainers);
        if (failedContainers.size() > 0) {
            this.resultFileWriter.append("false");
            Iterator<String> i$ = failedContainers.iterator();
            if (i$.hasNext()) {
                String containerName = i$.next();
                LogFactory.writeLogEntry(this.getClass(), "Could not deploy HDI container " + containerName);
                throw new HdbException("Could not deploy HDI container " + containerName);
            }
        }
    }

    private List<String> repeatCreateDeployContainers(JdbcConnection connection, String CONTAINER_GROUP_NAME, List<String> containers, List<String> failedContainers) {
        ArrayList<String> waitingForRefsContainer = new ArrayList<String>();
        for (String containerName : containers) {
            if (this.hasNotCreatedRefs(containerName, CONTAINER_GROUP_NAME)) {
                waitingForRefsContainer.add(containerName);
                continue;
            }
            try {
                this.createContainer(connection, CONTAINER_GROUP_NAME, containerName);
                this.grantContainerPriv2AbapUser(connection, CONTAINER_GROUP_NAME, containerName);
                this.configLibContainer(connection, CONTAINER_GROUP_NAME, containerName);
                this.writeContainer(connection, CONTAINER_GROUP_NAME, containerName);
                this.analyzeContainerRefsExecGrants(connection, CONTAINER_GROUP_NAME, containerName, failedContainers);
                this.deployContainer(connection, CONTAINER_GROUP_NAME, containerName);
            }
            catch (Exception e) {
                failedContainers.add(containerName);
            }
        }
        if (0 < waitingForRefsContainer.size() && waitingForRefsContainer.size() < containers.size()) {
            this.repeatCreateDeployContainers(connection, CONTAINER_GROUP_NAME, waitingForRefsContainer, failedContainers);
        }
        return failedContainers;
    }

    private boolean hasNotCreatedRefs(String containerName, String CONTAINER_GROUP_NAME) {
        String logicalContainerName = this.physicalLogicalContainers.get(containerName);
        if (null == logicalContainerName || logicalContainerName.equals("")) {
            LogFactory.writeLogEntry(this.getClass(), "Could not find LOGICAL_CONTAINER_NAME FROM table CTS_AMHC_MAP for container " + containerName);
            return false;
        }
        List<CTS_AMHC_REF_Entry> refs = this.logicalContainersRefs.get(logicalContainerName);
        if (null == refs) {
            return false;
        }
        for (CTS_AMHC_REF_Entry ref : refs) {
            String refContainerName;
            String refLogical = ref.getREF_LOGICAL_CONTAINER_NAME();
            String type = ref.getREF_TYPE();
            if (refLogical.equalsIgnoreCase(this.SAP_ABAP) || null == type || !type.equalsIgnoreCase(this.REF_TYPE_C) || this.containerExists(this.connection, CONTAINER_GROUP_NAME, refContainerName = this.logicalPhysicalContainers.get(refLogical))) continue;
            return true;
        }
        return false;
    }

    private void analyzeContainerRefsExecGrants(JdbcConnection connection, String CONTAINER_GROUP_NAME, String containerName, List<String> problemContainers) {
        String logicalContainerName = this.physicalLogicalContainers.get(containerName);
        if (null == logicalContainerName || logicalContainerName.equals("")) {
            problemContainers.add(containerName);
            LogFactory.writeLogEntry(this.getClass(), "Could not find LOGICAL_CONTAINER_NAME FROM table CTS_AMHC_MAP for container " + containerName);
            return;
        }
        List<CTS_AMHC_REF_Entry> refs = this.logicalContainersRefs.get(logicalContainerName);
        if (null == refs) {
            return;
        }
        for (CTS_AMHC_REF_Entry ref : refs) {
            String logical = ref.getREF_LOGICAL_CONTAINER_NAME();
            String type = ref.getREF_TYPE();
            if (logical.equalsIgnoreCase(this.SAP_ABAP)) {
                this.grantAbapUserPriv2ContainerOwner(connection, CONTAINER_GROUP_NAME, containerName);
                continue;
            }
            if (null == type || !type.equalsIgnoreCase(this.REF_TYPE_C)) continue;
            String refContainerName = this.logicalPhysicalContainers.get(logical);
            this.grantContainerPriv2ContainerOwner(connection, CONTAINER_GROUP_NAME, containerName, refContainerName);
        }
    }

    private void grantContainerPriv2ContainerOwner(JdbcConnection connection, String CONTAINER_GROUP_NAME, String containerName, String refContainerName) {
        String createRoles = "CREATE LOCAL TEMPORARY COLUMN TABLE #ROLES LIKE _SYS_DI.TT_SCHEMA_ROLES";
        String insertInRoles = "INSERT INTO #ROLES(ROLE_NAME, PRINCIPAL_SCHEMA_NAME, PRINCIPAL_NAME) VALUES ('container_access', '', '<containerName>#OO')";
        String callProc = "CALL <refContainerName>#DI.GRANT_CONTAINER_SCHEMA_ROLES(#ROLES, _SYS_DI.T_NO_PARAMETERS, ?, ?, ?)";
        String dropRoles = "DROP TABLE #ROLES";
        insertInRoles = insertInRoles.replace("<containerName>", containerName);
        callProc = callProc.replace("<refContainerName>", refContainerName);
        try {
            connection.executeSQLCommand(createRoles);
            connection.executeSQLCommand(insertInRoles);
            LogFactory.writeLogEntry(HDIMigrate.class, "Run SQL command: " + callProc);
            LogFactory.writeLogEntry(this.getClass(), "Grant " + refContainerName + ".container_access# Role to " + containerName + "#OO");
            CallableStatement cs = connection.getConnection().prepareCall("{" + callProc + "}");
            cs.registerOutParameter(1, -9);
            cs.execute();
            int rc = cs.getInt(1);
            connection.executeSQLCommand(dropRoles);
            if (rc < 0) {
                LogFactory.writeLogEntry(this.getClass(), "Could not Grant " + refContainerName + ".container_access# Role to " + containerName + "#OO");
                throw new HdbException("Could not Grant " + refContainerName + ".container_access# Role to " + containerName + "#OO");
            }
        }
        catch (SQLException e) {
            connection.executeSQLCommand(dropRoles);
            throw new HdbException("Could not Grant " + refContainerName + ".container_access# Role to " + containerName + "#OO");
        }
    }

    private void fillLogicalPhysicalContainerMapOnSource(JdbcConnection connection, String CONTAINER_GROUP_NAME, List<String> container) {
        String select_CTS_AMHC_MAP = "SELECT LOGICAL_CONTAINER_NAME AS LOGICAL, PHYSICAL_CONTAINER_NAME AS PHYSICAL FROM CTS_AMHC_MAP";
        Statement stmt = null;
        ResultSet resultSet = null;
        Connection conn = connection.getConnection();
        try {
            stmt = conn.createStatement();
            LogFactory.writeLogEntry(HDIMigrate.class, "Run SQL command: " + select_CTS_AMHC_MAP);
            resultSet = stmt.executeQuery(select_CTS_AMHC_MAP);
            this.createWriter(this.containerLogicalPhysicalFile);
            this.writer.println("###LOGICAL_CONTAINER_NAME,PHYSICAL_CONTAINER_NAME###");
            while (resultSet.next()) {
                String logical = resultSet.getString("LOGICAL");
                String physical = resultSet.getString("PHYSICAL");
                LogFactory.writeLogEntry(this.getClass(), "LOGICAL_CONTAINER_NAME: " + logical + " -> PHYSICAL_CONTAINER_NAME: " + physical);
                this.logicalPhysicalContainers.put(logical, physical);
                this.physicalLogicalContainers.put(physical, logical);
                this.writer.println(logical + "," + physical);
            }
            this.writer.flush();
            this.writer.close();
        }
        catch (SQLException e) {
            try {
                String message = "Error during execution of SQL command: " + select_CTS_AMHC_MAP + " " + e.getMessage();
                LogFactory.writeLogEntry(this.getClass(), message);
                throw new HdbException(message, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resultSet);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(resultSet);
    }

    private void fillLogicalPhysicalContainerMapOnTarget() {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            this.createReader(this.containerLogicalPhysicalFile);
            if (null != this.reader) {
                String l;
                while ((l = this.reader.readLine()) != null) {
                    l.trim();
                    if (l.length() <= 0) continue;
                    lines.add(l);
                }
            } else {
                LogFactory.writeLogEntry(this.getClass(), "No reader for " + this.containerLogicalPhysicalFile + " file found. Nothing to do.");
            }
            this.reader.close();
        }
        catch (Exception e) {
            throw new HdbException(e.getMessage());
        }
        for (String line : lines) {
            if (line.startsWith("###")) continue;
            String[] parts = line.split(",");
            String logical = parts[0];
            String physical = parts[1];
            this.logicalPhysicalContainers.put(logical, physical);
            this.physicalLogicalContainers.put(physical, logical);
        }
    }

    private void fillLogicalContainersRefsOnSource(JdbcConnection connection, String CONTAINER_GROUP_NAME, List<String> containers) {
        String select_CTS_AMHC_REF = "SELECT LOGICAL_CONTAINER_NAME AS LOGICAL, REF_LOGICAL_CONTAINER_NAME AS REF_LOGICAL, REF_TYPE AS TYPE FROM CTS_AMHC_REF";
        Statement stmt = null;
        ResultSet resultSet = null;
        Connection conn = connection.getConnection();
        try {
            LogFactory.writeLogEntry(HDIMigrate.class, "Run SQL command: " + select_CTS_AMHC_REF);
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(select_CTS_AMHC_REF);
            this.createWriter(this.containerRefFile);
            this.writer.println("###LOGICAL_CONTAINER_NAME,REF_LOGICAL_CONTAINER_NAME,REF_TYPE###");
            while (resultSet.next()) {
                String logical = resultSet.getString("LOGICAL");
                String refLogical = resultSet.getString("REF_LOGICAL");
                String type = resultSet.getString("TYPE");
                List<CTS_AMHC_REF_Entry> found = this.logicalContainersRefs.get(logical);
                if (null == found) {
                    found = new ArrayList<CTS_AMHC_REF_Entry>();
                }
                CTS_AMHC_REF_Entry entry = new CTS_AMHC_REF_Entry(logical, refLogical, type);
                found.add(entry);
                this.logicalContainersRefs.put(logical, found);
                this.writer.println(logical + "," + refLogical + "," + type);
            }
            this.writer.flush();
            this.writer.close();
        }
        catch (SQLException e) {
            try {
                String message = "Error during execution of SQL command: " + select_CTS_AMHC_REF + " " + e.getMessage();
                LogFactory.writeLogEntry(this.getClass(), message);
                throw new HdbException(message, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resultSet);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(resultSet);
    }

    private void fillLogicalContainersRefsOnTarget() {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            this.createReader(this.containerRefFile);
            if (null != this.reader) {
                String l;
                while ((l = this.reader.readLine()) != null) {
                    l.trim();
                    if (l.length() <= 0) continue;
                    lines.add(l);
                }
            } else {
                LogFactory.writeLogEntry(this.getClass(), "No reader for " + this.containerRefFile + " file found. Nothing to do.");
            }
            this.reader.close();
        }
        catch (Exception e) {
            throw new HdbException(e.getMessage());
        }
        for (String line : lines) {
            if (line.startsWith("###")) continue;
            String[] parts = line.split(",");
            String logical = parts[0];
            String refLogical = parts[1];
            String type = parts.length > 2 ? parts[2] : "";
            List<CTS_AMHC_REF_Entry> found = this.logicalContainersRefs.get(logical);
            if (null == found) {
                found = new ArrayList<CTS_AMHC_REF_Entry>();
            }
            CTS_AMHC_REF_Entry entry = new CTS_AMHC_REF_Entry(logical, refLogical, type);
            found.add(entry);
            this.logicalContainersRefs.put(logical, found);
        }
    }

    private void configLibContainer(JdbcConnection connection2, String cONTAINER_GROUP_NAME, String containerName) {
        String sql = "CALL <CONTAINER>#DI.CONFIGURE_LIBRARIES(_SYS_DI.T_DEFAULT_LIBRARIES, _SYS_DI.T_NO_PARAMETERS, ?, ?, ?)";
        sql = sql.replace("<CONTAINER>", containerName);
        try {
            LogFactory.writeLogEntry(HDIMigrate.class, "Run SQL command: " + sql);
            CallableStatement cs = this.connection.getConnection().prepareCall("{" + sql + "}");
            cs.registerOutParameter(1, -9);
            cs.execute();
            int rc = cs.getInt(1);
            LogFactory.writeLogEntry(this.getClass(), "Libraries for container " + containerName + " configured");
            if (rc < 0) {
                LogFactory.writeLogEntry(this.getClass(), "Could not configure libraries for HDI container " + containerName);
                throw new HdbException("Could not configure libraries for HDI container " + containerName + " rc=" + rc);
            }
        }
        catch (SQLException e) {
            throw new HdbException("Could not configure libraries for HDI container " + containerName);
        }
    }

    private void deployContainer(JdbcConnection connection, String CONTAINER_GROUP_NAME, String containerName) {
        String deployPathsSql = "CREATE LOCAL TEMPORARY COLUMN TABLE #DEPLOY_PATHS LIKE _SYS_DI.TT_FILESFOLDERS";
        String undeployPathsSql = "CREATE LOCAL TEMPORARY COLUMN TABLE #UNDEPLOY_PATHS LIKE _SYS_DI.TT_FILESFOLDERS";
        String insertDeployPathsSql = "INSERT INTO #DEPLOY_PATHS (PATH) SELECT PATH from " + SUM_HDI_DEPLOYED + " WHERE PHYSICAL_CONTAINER_NAME = '<CONTAINER>' AND RIGHT(PATH, 1) <> '/'";
        insertDeployPathsSql = insertDeployPathsSql.replace("<CONTAINER>", containerName);
        String pathParamSql = "CREATE LOCAL TEMPORARY COLUMN TABLE #PATH_PARAMETERS LIKE _SYS_DI.TT_FILESFOLDERS_PARAMETERS";
        String dropDeployPathSql = "DROP TABLE #DEPLOY_PATHS";
        String dropUndeployPathSql = "DROP TABLE #UNDEPLOY_PATHS";
        String dropPathParamSql = "DROP TABLE #PATH_PARAMETERS";
        String makeSql = "CALL <CONTAINER>#DI.MAKE(#DEPLOY_PATHS, #UNDEPLOY_PATHS, #PATH_PARAMETERS, _SYS_DI.T_NO_PARAMETERS, ?, ?, ?)";
        makeSql = makeSql.replace("<CONTAINER>", containerName);
        connection.executeSQLCommand(deployPathsSql);
        connection.executeSQLCommand(undeployPathsSql);
        connection.executeSQLCommand(insertDeployPathsSql);
        connection.executeSQLCommand(pathParamSql);
        LogFactory.writeLogEntry(HDIMigrate.class, "Run SQL command: " + makeSql);
        try {
            CallableStatement cs = connection.getConnection().prepareCall("{" + makeSql + "}");
            cs.registerOutParameter(1, -9);
            cs.execute();
            int rc = cs.getInt(1);
            ResultSet rs = cs.getResultSet();
            while (rs.next()) {
                LogFactory.writeLogEntry(this.getClass(), rs.getString("MESSAGE"));
            }
            if (rc < 0) {
                connection.executeSQLCommand(dropDeployPathSql);
                connection.executeSQLCommand(dropUndeployPathSql);
                connection.executeSQLCommand(dropPathParamSql);
                LogFactory.writeLogEntry(this.getClass(), "Could not deploy HDI container " + containerName + ". rc=" + rc);
                throw new HdbException("Could not deploy HDI container " + containerName);
            }
        }
        catch (SQLException e) {
            connection.executeSQLCommand(dropDeployPathSql);
            connection.executeSQLCommand(dropUndeployPathSql);
            connection.executeSQLCommand(dropPathParamSql);
            throw new HdbException("Could not deploy HDI container " + containerName);
        }
        connection.executeSQLCommand(dropDeployPathSql);
        connection.executeSQLCommand(dropUndeployPathSql);
        connection.executeSQLCommand(dropPathParamSql);
    }

    private void writeContainer(JdbcConnection connection, String CONTAINER_GROUP_NAME, String containerName) {
        String createPaths = "CREATE LOCAL TEMPORARY COLUMN TABLE #PATHS LIKE _SYS_DI.TT_FILESFOLDERS_CONTENT";
        String dropPaths = "DROP TABLE #PATHS";
        String insertInPaths = "INSERT INTO #PATHS SELECT PATH, CONTENT FROM " + SUM_HDI_DEPLOYED + " WHERE PHYSICAL_CONTAINER_NAME = '<CONTAINER>'";
        insertInPaths = insertInPaths.replace("<CONTAINER>", containerName);
        String diWriteSql = "CALL <CONTAINER>#DI.WRITE(#PATHS, _SYS_DI.T_NO_PARAMETERS, ?, ?, ?)";
        diWriteSql = diWriteSql.replace("<CONTAINER>", containerName);
        try {
            connection.executeSQLCommand(createPaths);
            connection.executeSQLCommand(insertInPaths);
            LogFactory.writeLogEntry(HDIMigrate.class, "Run SQL command: " + diWriteSql);
            CallableStatement cs = connection.getConnection().prepareCall("{" + diWriteSql + "}");
            cs.registerOutParameter(1, -9);
            cs.execute();
            int rc = cs.getInt(1);
            ResultSet rs = cs.getResultSet();
            while (rs.next()) {
                LogFactory.writeLogEntry(this.getClass(), rs.getString("MESSAGE"));
            }
            connection.executeSQLCommand(dropPaths);
            if (rc < 0) {
                LogFactory.writeLogEntry(this.getClass(), "Could not write work file system for HDI container " + containerName + ". rc=" + rc);
                throw new HdbException("Could not write work file system for HDI container " + containerName);
            }
        }
        catch (SQLException e) {
            connection.executeSQLCommand(dropPaths);
            throw new HdbException("Could not write work file system for HDI container " + containerName);
        }
    }

    private void createContainer(JdbcConnection connection, String CONTAINER_GROUP_NAME, String containerName) {
        if (this.containerExists(connection, CONTAINER_GROUP_NAME, containerName)) {
            LogFactory.writeLogEntry(this.getClass(), "HDI container " + containerName + " already exists. Continue with next steps.");
        } else {
            String createContainerSql = "CALL _SYS_DI#<CONTAINER_GROUP_NAME>.CREATE_CONTAINER('<CONTAINER>', _SYS_DI.T_NO_PARAMETERS, ?, ?, ?)";
            createContainerSql = createContainerSql.replace("<CONTAINER>", containerName);
            createContainerSql = createContainerSql.replace("<CONTAINER_GROUP_NAME>", CONTAINER_GROUP_NAME);
            LogFactory.writeLogEntry(HDIMigrate.class, "Run SQL command: " + createContainerSql);
            try {
                CallableStatement cs = connection.getConnection().prepareCall("{" + createContainerSql + "}");
                cs.registerOutParameter(1, -9);
                cs.execute();
                int rc = cs.getInt(1);
                ResultSet rs = cs.getResultSet();
                while (rs.next()) {
                    LogFactory.writeLogEntry(this.getClass(), rs.getString("MESSAGE"));
                }
                if (rc < 0) {
                    LogFactory.writeLogEntry(this.getClass(), "Could not create HDI container " + containerName + ". rc=" + rc);
                    throw new HdbException("Could not create HDI container " + containerName);
                }
            }
            catch (SQLException e) {
                throw new HdbException("Could not create container " + containerName);
            }
        }
    }

    private void grantAbapUserPriv2ContainerOwner(JdbcConnection connection, String CONTAINER_GROUP_NAME, String containerName) {
        String grant = "GRANT SELECT ON SCHEMA " + this.databaseUser.getName().get() + " TO \"" + containerName + "#OO\"";
        connection.executeSQLCommand(grant);
    }

    private void grantContainerPriv2AbapUser(JdbcConnection connection, String CONTAINER_GROUP_NAME, String containerName) {
        connection.setConnectUser(this.databaseUser);
        String drop = "DROP TABLE #PRIVILEGES";
        try {
            connection.executeSQLCommand("CREATE LOCAL TEMPORARY COLUMN TABLE #PRIVILEGES LIKE _SYS_DI.TT_API_PRIVILEGES");
            connection.executeSQLCommand("INSERT INTO #PRIVILEGES (PRINCIPAL_NAME, PRIVILEGE_NAME, OBJECT_NAME) SELECT '" + this.databaseUser.getName().get() + "', PRIVILEGE_NAME, OBJECT_NAME FROM _SYS_DI.T_DEFAULT_CONTAINER_ADMIN_PRIVILEGES");
            String callProcedure = "CALL _SYS_DI#" + CONTAINER_GROUP_NAME + ".GRANT_CONTAINER_API_PRIVILEGES('" + containerName + "', #PRIVILEGES, _SYS_DI.T_NO_PARAMETERS, ?, ?, ?)";
            LogFactory.writeLogEntry(HDIMigrate.class, "Run SQL command: " + callProcedure);
            CallableStatement cs = connection.getConnection().prepareCall("{" + callProcedure + "}");
            cs.registerOutParameter(1, -9);
            cs.execute();
            int rc = cs.getInt(1);
            LogFactory.writeLogEntry(this.getClass(), "Grant privileges to ABAP user for HDI container " + containerName + " end with rc=" + rc);
            connection.executeSQLCommand(drop);
            if (rc < 0) {
                LogFactory.writeLogEntry(this.getClass(), "Could not grant privileges to ABAP user for HDI container " + containerName + ". rc=" + rc);
                throw new HdbException("Could not grant privileges to ABAP user for HDI container " + containerName);
            }
        }
        catch (HdbException e) {
            connection.executeSQLCommand(drop);
            String message = e.getMessage();
            if (message.contains("invalid table name") && message.contains("GRANT_CONTAINER_API_PRIVILEGES")) {
                LogFactory.writeLogEntry(HDIMigrate.class, "Could not grant privileges via GRANT_CONTAINER_API_PRIVILEGES");
                return;
            }
            throw e;
        }
        catch (SQLException e) {
            connection.executeSQLCommand(drop);
            throw new HdbException(e);
        }
    }

    private boolean containerExists(JdbcConnection connection, String CONTAINER_GROUP_NAME, String containerName) {
        connection.setConnectUser(this.systemUser);
        String sql = "select COUNT(*) from _SYS_DI.M_ALL_CONTAINERS where CONTAINER_GROUP_NAME = '" + CONTAINER_GROUP_NAME + "' AND " + "CONTAINER_NAME = '" + containerName + "'";
        List<String> result = connection.executeSQLCommand(sql);
        connection.setConnectUser(this.databaseUser);
        return result.get(0).equals("1");
    }

    public void setContainerInfoFile(CmdClazzParameterMap parameters) {
        if (parameters.containsKey(CmdClazzParameterName.HDI_CONTAINER_INFO_FILE)) {
            String infoPath = parameters.get(CmdClazzParameterName.HDI_CONTAINER_INFO_FILE).getValue();
            this.containerInfoFile = new File(infoPath);
        } else {
            this.containerInfoFile = new File("./HdiContainers");
        }
    }

    public void setContainerRefFile() {
        this.containerRefFile = new File("./HdiContainerRefs");
    }

    public void setContainerLogicalPhysicaFile() {
        this.containerLogicalPhysicalFile = new File("./HdiContainersMap");
    }

    private void createContainerInfoFile() {
        if (!this.containerInfoFile.exists()) {
            try {
                boolean created = this.containerInfoFile.createNewFile();
                if (!created) {
                    throw new HdbException(this.containerInfoFile + " could not be created!");
                }
            }
            catch (IOException e) {
                throw new HdbException(e.getMessage());
            }
        }
    }

    private void createReader(File file) {
        if (!file.exists() || !file.isFile()) {
            LogFactory.writeLogEntry(this.getClass(), "File" + file + " not found. Nothing to do.");
            throw new HdbException("File " + file + " not found. Better stop");
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw new HdbException(e.getMessage());
        }
        this.reader = br;
    }

    private void createWriter(File file) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(file, false));
        }
        catch (FileNotFoundException e) {
            throw new HdbException(e.getMessage());
        }
        catch (IOException e) {
            throw new HdbException(e.getMessage());
        }
        this.writer = pw;
    }

    private void findOptions() {
        String[] options = this.parameters.getOptions();
        if (null != options && options.length > 0) {
            for (String option : options) {
                if (option.equalsIgnoreCase("TARGET")) {
                    this.source = false;
                }
                if (!option.startsWith("destvers=")) continue;
                String destvers = option.substring(option.indexOf("=") + 1);
                try {
                    Integer.parseInt(destvers);
                    LogFactory.writeLogEntry(UpdateRepairRolesAndPrivileges.class, "Using: " + option);
                    HdbsllibMem mem = HdbsllibMem.getInstance();
                    mem.save(HdbsllibMem.DESTVERS, destvers);
                }
                catch (NumberFormatException nfe) {
                    destvers = null;
                }
            }
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }

    class CTS_AMHC_REF_Entry {
        String LOGICAL_CONTAINER_NAME;
        String REF_LOGICAL_CONTAINER_NAME;
        String REF_TYPE;

        public CTS_AMHC_REF_Entry(String LOGICAL_CONTAINER_NAME, String REF_LOGICAL_CONTAINER_NAME, String REF_TYPE) {
            this.LOGICAL_CONTAINER_NAME = LOGICAL_CONTAINER_NAME;
            this.REF_LOGICAL_CONTAINER_NAME = REF_LOGICAL_CONTAINER_NAME;
            this.REF_TYPE = REF_TYPE;
        }

        public String getLOGICAL_CONTAINER_NAME() {
            return this.LOGICAL_CONTAINER_NAME;
        }

        public void setLOGICAL_CONTAINER_NAME(String LOGICAL_CONTAINER_NAME) {
            this.LOGICAL_CONTAINER_NAME = LOGICAL_CONTAINER_NAME;
        }

        public String getREF_LOGICAL_CONTAINER_NAME() {
            return this.REF_LOGICAL_CONTAINER_NAME;
        }

        public void setREF_LOGICAL_CONTAINER_NAME(String REF_LOGICAL_CONTAINER_NAME) {
            this.REF_LOGICAL_CONTAINER_NAME = REF_LOGICAL_CONTAINER_NAME;
        }

        public String getREF_TYPE() {
            return this.REF_TYPE;
        }

        public void setREF_TYPE(String REF_TYPE) {
            this.REF_TYPE = REF_TYPE;
        }
    }
}

