/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.hdi.HDIConstants;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.SystemDatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.HDICreateContainerGroupAddPrivilegesSQLs;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.List;

public class HDITurnOnMultiDB
extends BatchExecutionBase {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private DatabaseSystemUser systemDatabaseUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private Sid tenantName = null;

    protected HDITurnOnMultiDB() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.systemDatabaseUser = SystemDatabaseSystemUserFactory.getUser(parameters);
        this.tenantName = new Sid(parameters);
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        this.turnOnHdi();
    }

    private void turnOnHdi() {
        this.connectToTenant();
        List<String> result = this.connection.executeSQLCommand(HDICreateContainerGroupAddPrivilegesSQLs.DISERVER_CHECK_SQL);
        if (result.get(0).equalsIgnoreCase("0")) {
            String location = new String("");
            if (this.database.isScaleOut(this.connection, this.systemUser)) {
                String master = this.database.getMasterHost(this.connection, this.systemUser);
                location = " AT LOCATION '" + master + "'";
            }
            LogFactory.writeLogEntry(this.getClass(), "Turning on HDI...");
            this.connectToSystemDB();
            this.connection.executeSQLCommand("ALTER DATABASE " + this.tenantName.get() + " ADD 'diserver'" + location);
            this.connectToTenant();
            result = this.connection.executeSQLCommand(HDICreateContainerGroupAddPrivilegesSQLs.DISERVER_CHECK_SQL);
            if (!result.get(0).equalsIgnoreCase("1")) {
                if (null != this.resultFileWriter) {
                    this.resultFileWriter.append("false");
                }
                throw new HdbException(this.connection.toString() + ", Could not turn on HDI!");
            }
        }
        LogFactory.writeLogEntry(this.getClass(), "Found active diserver - HDI is turned on.");
        if (null != this.resultFileWriter) {
            this.resultFileWriter.append("true");
        }
        if (null != this.resultKeeper) {
            this.resultKeeper.addResult(HDIConstants.DISERVER_IS_ACTIVE, "true");
        }
    }

    private void connectToSystemDB() {
        this.connection.setSid(new Sid("SYSTEMDB"));
        this.connection.setConnectUser(this.systemDatabaseUser);
    }

    private void connectToTenant() {
        this.connection.setSid(new Sid(this.tenantName.get()));
        this.connection.setConnectUser(this.systemUser);
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

