/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.HDICreateContainerGroupAddPrivilegesSQLs;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.List;

public class HDITurnOnSingleDB
implements CmdClazz {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;

    protected HDITurnOnSingleDB() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        this.connection.setConnectUser(this.systemUser);
        this.turnOnHdi();
    }

    private void turnOnHdi() {
        List<String> result = this.connection.executeSQLCommand(HDICreateContainerGroupAddPrivilegesSQLs.DISERVER_CHECK_SQL);
        if (result.get(0).equalsIgnoreCase("0")) {
            LogFactory.writeLogEntry(this.getClass(), "Turning on HDI...");
            DatabaseConfiguration config = new DatabaseConfiguration(this.connection, this.systemUser, DatabaseConfiguration.ConfigFileName.DAEMON_INI);
            DatabaseConfigurationSection section = config.getSection("diserver");
            section.setParameter("instances", "1");
            result = this.connection.executeSQLCommand(HDICreateContainerGroupAddPrivilegesSQLs.DISERVER_CHECK_SQL);
            if (!result.get(0).equalsIgnoreCase("1")) {
                if (null != this.resultFileWriter) {
                    this.resultFileWriter.append("false");
                }
                throw new HdbException(this.connection.toString() + ", Could not turn on HDI!");
            }
        }
        LogFactory.writeLogEntry(this.getClass(), "Found active diserver - HDI is turned on.");
        if (null != this.resultFileWriter) {
            this.resultFileWriter.append("true");
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

