/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.operating.system.HdbEnvironmentFactory;
import com.sap.hdb.sl.lib.operating.system.HdbEnvironmentVariable;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class HdbconsShrink
implements CmdClazz {
    private Database database;
    private DatabaseSystemUser systemUser;
    private JdbcDriver jdbcDriver;
    private JdbcConnection connection;
    private ResultFileWriter resultFileWriter;
    HdbEnvironmentVariable resman_shrink_var;
    String percentage = "0.50";

    protected HdbconsShrink() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.readShrinkParams(parameters);
    }

    @Override
    public void execute() {
        String value;
        if (this.resman_shrink_var.isSet() && ((value = this.resman_shrink_var.getValue().get()).equalsIgnoreCase("false") || value.equalsIgnoreCase("0") || value.equalsIgnoreCase("no"))) {
            this.resultFileWriter.append("resman_shrink off");
            LogFactory.writeLogEntry(this.getClass(), "resman_shrink is not active, nothing to do.");
            return;
        }
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
            this.connection.setConnectUser(this.systemUser);
        }
        String size = this.findSizeForShrink();
        List<String> host_ports = this.connection.executeSQLCommand("select HOST || ':' || PORT from \"SYS\".\"M_SERVICES\" where SERVICE_NAME = 'indexserver' and COORDINATOR_TYPE IN ('MASTER', 'COORDINATOR')");
        Connection conn = this.connection.getConnection();
        for (String host_port : host_ports) {
            try {
                CallableStatement cs = conn.prepareCall("{call SYS.MANAGEMENT_CONSOLE_PROC(?, ?, ?)}");
                cs.setString(1, "resman shrink -s " + size);
                cs.setString(2, host_port);
                cs.registerOutParameter(3, 12);
                cs.execute();
                String result = cs.getString(3);
                if (result.contains("OK")) {
                    this.resultFileWriter.append("0");
                    this.resultFileWriter.append(result);
                    LogFactory.writeLogEntry(this.getClass(), result);
                    continue;
                }
                this.resultFileWriter.append("1");
                this.resultFileWriter.append(result);
                LogFactory.writeLogEntry(this.getClass(), result);
            }
            catch (SQLException e) {
                String message = "Error during execution of procedure SYS.MANAGEMENT_CONSOLE_PROC: " + e.getMessage();
                LogFactory.writeLogEntry(this.getClass(), message);
                this.resultFileWriter.append("-1");
                this.resultFileWriter.append(message);
                this.connection.closeConnection();
                throw new HdbException(message);
            }
        }
    }

    private String findSizeForShrink() {
        List<String> result = this.connection.executeSQLCommand("select ALLOCATION_LIMIT*" + this.percentage + " as size_for_shrink from SYS.M_HOST_RESOURCE_UTILIZATION");
        String size = result.get(0);
        size = size.substring(0, size.indexOf("."));
        return size;
    }

    public void readShrinkParams(CmdClazzParameterMap parameters) {
        String[] parts;
        String resmanEnv;
        this.resman_shrink_var = HdbEnvironmentFactory.getVariable("resman_shrink");
        String resmanParams = "";
        if (parameters.containsKey(CmdClazzParameterName.ADD_OPTIONS)) {
            resmanParams = parameters.get(CmdClazzParameterName.ADD_OPTIONS).getValue();
        }
        if (this.resman_shrink_var.isSet() && (resmanEnv = this.resman_shrink_var.getValue().get()).contains("percentage=")) {
            resmanParams = resmanEnv;
        }
        LogFactory.writeLogEntry(this.getClass(), "Received resman shrink parameteres: " + resmanParams);
        resmanParams.trim();
        for (String option : parts = resmanParams.split(",")) {
            if (option.startsWith("percentage=")) {
                String found = option.substring(option.indexOf("=") + 1);
                if (!found.startsWith("0.")) continue;
                this.percentage = found;
                continue;
            }
            LogFactory.writeLogEntry(this.getClass(), "Unknown option " + option);
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

