/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.operating.system.HdbEnvironmentFactory;
import com.sap.hdb.sl.lib.operating.system.HdbEnvironmentVariableList;
import com.sap.hdb.sl.lib.operating.system.HdbEnvironmentVariableName;
import com.sap.hdb.sl.lib.operating.system.OsToolBox;
import com.sap.hdb.sl.lib.operating.system.OsToolboxFactory;
import com.sap.hdb.sl.lib.utils.GenericInstallationParameter;
import com.sap.hdb.sl.lib.utils.HdbInst;
import com.sap.hdb.sl.lib.utils.HdbInstFactory;
import com.sap.hdb.sl.lib.utils.InstallationParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.ArrayList;
import java.util.List;

public class InstallClient
implements CmdClazz {
    private CmdClazzParameterMap parameters = null;
    private HdbInst hdbInst = null;
    private OsToolBox os = null;
    private HdbEnvironmentVariableList envVarList = HdbEnvironmentFactory.getHdbVariables();

    protected InstallClient() {
    }

    @Override
    public void execute() {
        if (null == this.hdbInst) {
            this.hdbInst = HdbInstFactory.getHdbInst(this.parameters);
        }
        if (null == this.os) {
            this.os = OsToolboxFactory.getToolbox();
        }
        this.addInstallationParameters();
        if (this.envVarList.contains(HdbEnvironmentVariableName.EnvironmentVariableName.HDB_INSTALLATION_PARAMETER)) {
            List<InstallationParameter> additionalInstallParameters = GenericInstallationParameter.getParameters(this.envVarList, OsToolboxFactory.getToolbox(), CmdClazzName.INSTALL_CLIENT);
            this.hdbInst.addInstallationParameters(additionalInstallParameters);
        }
        this.hdbInst.installClient();
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.parameters = parameters;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
    }

    private void addInstallationParameters() {
        List<CmdClazzParameterName> mandatoryParameterNames = this.getMandatoryInstallationParameters();
        List<CmdClazzParameterName> optionalParameterNames = this.getOptionalInstallationParameters();
        this.addInstallationParameters(mandatoryParameterNames, false);
        this.addInstallationParameters(optionalParameterNames, true);
    }

    private List<CmdClazzParameterName> getOptionalInstallationParameters() {
        ArrayList<CmdClazzParameterName> optionalParameters = new ArrayList<CmdClazzParameterName>();
        optionalParameters.add(CmdClazzParameterName.DATABASE_HOSTNAME);
        return optionalParameters;
    }

    private List<CmdClazzParameterName> getMandatoryInstallationParameters() {
        ArrayList<CmdClazzParameterName> mandatoryParameters = new ArrayList<CmdClazzParameterName>();
        mandatoryParameters.add(CmdClazzParameterName.INSTALLATION_PATH);
        if (this.os.onUnix()) {
            mandatoryParameters.add(CmdClazzParameterName.SAP_SID);
        }
        return mandatoryParameters;
    }

    private void addInstallationParameters(List<CmdClazzParameterName> parameterNames, boolean ignoreNonExistingParameterNames) {
        for (CmdClazzParameterName name : parameterNames) {
            if (ignoreNonExistingParameterNames && !this.parameters.containsKey(name)) continue;
            CmdClazzParameter parameter = this.parameters.get(name);
            if (parameter instanceof InstallationParameter) {
                this.hdbInst.addInstallationParameter((InstallationParameter)((Object)parameter));
                continue;
            }
            throw new HdbException(name + " must be instance of " + InstallationParameter.class);
        }
    }

    public void setHdbInst(HdbInst hdbInst) {
        this.hdbInst = hdbInst;
    }

    public void setOsToolBox(OsToolBox os) {
        this.os = os;
    }
}

