/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.DatabaseTenant;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.SAPControlWsdlUrl;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.sapcontrol.ArrayOfString;
import com.sap.hdb.sl.lib.sapcontrol.SAPControlPortType;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.OperatingSystemUser;
import com.sap.hdb.sl.lib.user.OperatingSystemUserFactory;
import com.sap.hdb.sl.lib.user.SystemDatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import com.sap.hdb.sl.lib.user.name.OperatingSystemUserName;
import com.sap.hdb.sl.lib.user.password.DatabaseSqlUserPassword;
import com.sap.hdb.sl.lib.user.password.DatabaseSystemUserPassword;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import com.sap.hdb.sl.lib.utils.Archive;
import com.sap.hdb.sl.lib.utils.HdbLcm;
import com.sap.hdb.sl.lib.utils.HdbLcmFactory;
import com.sap.hdb.sl.lib.utils.HdbUpdReg;
import com.sap.hdb.sl.lib.utils.InstallationParameter;
import com.sap.hdb.sl.lib.utils.SAPControlHelper;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.ws.Holder;

public class InstallHanaComponent
implements CmdClazz {
    private CmdClazzParameterMap parameters = null;
    private ResultFileWriter resultWriter;
    private Database database;
    private DatabaseSystemUser systemUser;
    private DatabaseSystemUser systemDatabaseSystemUser;
    private OperatingSystemUser osUser;
    private SAPControlWsdlUrl wsdlUrl;
    private JdbcDriver jdbcDriver;
    private String archiveLocation;
    private SAPControlHelper helper = new SAPControlHelper();
    private String archives;
    private String action;
    private String target;
    private int parallelJobs = 10;
    private String lastError = new String("No errors found.");
    private Sid tenantSid;
    private DatabaseSystemUserPassword systemUserPassword;
    private String PATH_SEPARATOR = new String(":");
    private Properties insertStatus = new Properties();
    private String installationComponents;
    private String hdblcmExe;
    private String deploymentType;

    protected InstallHanaComponent() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.parameters = parameters;
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        if (parameters.containsKey(CmdClazzParameterName.SYSTEM_DATABASE_SYSTEM_USER_PASSWORD)) {
            this.systemDatabaseSystemUser = SystemDatabaseSystemUserFactory.getUser(parameters);
        }
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.systemUserPassword = this.systemUser.getPassword();
        this.jdbcDriver = new JdbcDriver(parameters);
        this.action = parameters.get(CmdClazzParameterName.ARCHIVE_ACTION).getValue();
        if (parameters.containsKey(CmdClazzParameterName.ARCHIVE_TARGET)) {
            this.target = parameters.get(CmdClazzParameterName.ARCHIVE_TARGET).getValue();
        }
        if (parameters.containsKey(CmdClazzParameterName.PARALLEL_JOBS)) {
            this.parallelJobs = new Integer(parameters.get(CmdClazzParameterName.PARALLEL_JOBS).getValue());
        }
        this.hdblcmExe = parameters.get(CmdClazzParameterName.HDBLCMEXE).getValue();
        if (this.action.equals("INSTALL_LOCAL") || this.action.equals("INSERT_EXTRACT")) {
            this.installationComponents = parameters.get(CmdClazzParameterName.INSTALLATION_COMPONENTS).getValue();
        }
        if (!this.action.equals("INSTALL_LOCAL") && !this.action.equals("INSTALL_LOCAL_DU")) {
            this.archives = parameters.get(CmdClazzParameterName.ARCHIVES).getValue();
            this.tenantSid = new Sid(parameters.get(CmdClazzParameterName.DATABASE_SID).getValue());
            this.osUser = OperatingSystemUserFactory.getUser(new OperatingSystemUserName(parameters.get(CmdClazzParameterName.SIDADM_ID).getValue()), PasswordFactory.getOperatingSystemUserPassword(parameters.get(CmdClazzParameterName.SIDADM_PASSWORD).getValue()));
            this.wsdlUrl = new SAPControlWsdlUrl(parameters);
        }
        if (System.getProperty("os.name").toLowerCase(Locale.ENGLISH).indexOf("win") == 0) {
            this.PATH_SEPARATOR = ";";
        }
    }

    public boolean downloadAndExtractArchiveWithPython(SAPControlPortType port, String command) {
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        System.out.println("Export load jobs: Extracting Archives...");
        LogFactory.writeLogEntry(this.getClass(), "Execute: " + command);
        LogFactory.writeLogEntry(this.getClass(), "SAPControl method:  " + this.helper.getSapcontrolCall() + " -function OSExecute \"" + command + "\" 0 0");
        port.osExecute(command, 0, 0, this.tenantSid.getValue() + "_ARCHIVE_DOWNLOAD_EXTRACT_COMPONENT.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "Archives download/extract failed. For more details, check trace file " + this.tenantSid.getValue() + "_ARCHIVE_DOWNLOAD_EXTRACT_COMPONENT.trc.");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        LogFactory.writeLogEntry(this.getClass(), "Archives downloaded and extracted.");
        LogFactory.writeLogEntry(this.getClass(), "Deployment of HANA " + (this.deploymentType.equals("COMPONENT") ? "components" : "delivery units") + " successfully finished.");
        return true;
    }

    public boolean downloadAndUnzipArchiveWithPythonAsync(SAPControlPortType port, String command) {
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        System.out.println("Progress: Extracting Archives...");
        LogFactory.writeLogEntry(this.getClass(), "Execute: " + command);
        port.osExecute(command, 1, 0, this.tenantSid.getValue() + "_ARCHIVE_DOWNLOAD_EXTRACT.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "Archives download/extract failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        System.out.println("HANA Export Extract Progress: Process " + pid.value + "  started...");
        int extractPID = (Integer)pid.value;
        try {
            for (int i = 0; i < 200; ++i) {
                Thread.sleep(5000L);
                port.sendSignal(extractPID, "0");
                String ls = "/bin/sh -c ls\\ " + this.archiveLocation + "/.zips";
                System.out.println(ls);
                port.osExecute(ls, 1, 0, this.tenantSid.getValue() + "_LS_ZIPS.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
                System.out.println(((ArrayOfString)lines.value).getItem());
                ls = "/bin/sh -c ls\\ " + this.archiveLocation + "/*databackup*";
                System.out.println(ls);
                port.osExecute(ls, 1, 0, this.tenantSid.getValue() + "_LS_ZIPS.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
                System.out.println(((ArrayOfString)lines.value).getItem());
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        LogFactory.writeLogEntry(this.getClass(), "Archives downloaded and extracted.");
        return true;
    }

    public boolean insertAndUnzipArchiveWithPython(SAPControlPortType port, boolean unzip) {
        DatabaseSqlUser loadUser;
        JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        DatabaseSystemUser connectUser = this.systemUser;
        connection.setUserAndConnect(connectUser);
        DatabaseTenant tenant = InstanceFactory.getDatabaseTenant(this.tenantSid, connection);
        String tenantPort = tenant.getSqlPort(connection, connectUser).get();
        String systemdbPort = connection.getSystemdbPort();
        if (systemdbPort == null) {
            systemdbPort = tenantPort.substring(0, 3) + "13";
        }
        String location = this.target;
        String instanceDir = this.helper.getInstanceDirectory(port);
        if (location == null) {
            location = this.getDefaultLocation(connection, connectUser, instanceDir, port, "basepath_databackup");
        }
        location = this.action.equals("INSERT_EXTRACT") ? location + "/components" : location + "/deliveryUnits";
        this.archiveLocation = this.checkLocation(port, location);
        String script_py1 = this.archiveLocation + "/p_download_and_unzip.py";
        String[] listOfFiles = this.archives.split(this.PATH_SEPARATOR);
        String[] listOfTables = new String[listOfFiles.length];
        String listOfTablesPython = null;
        Thread[] archives = new Thread[listOfFiles.length];
        try {
            Statement stmt;
            block27: {
                loadUser = this.createLoadUser(connection);
                if (loadUser != null) {
                    connection.setConnectUser(loadUser);
                }
                stmt = connection.createStatement();
                try {
                    stmt.execute("DROP TABLE \"ARCHIVES\"");
                }
                catch (SQLException e) {
                    if (HdbException.INVALID_TABLE_NAME == e.getErrorCode()) break block27;
                    throw e;
                }
            }
            stmt.execute("CREATE TABLE \"ARCHIVES\" (ARCHIVE_TABLE CHAR(50), STATUS CHAR(12))");
            for (int i = 0; i < listOfFiles.length; ++i) {
                archives[i] = new Thread(new Archive(listOfFiles[i], this.jdbcDriver.get().getAbsolutePath(), connection.getUrl(), connection.getConnectUser().getName().get(), connection.getConnectUser().getPassword().get(), connection.getConnectProperties()));
                listOfTables[i] = Archive.getTableNameFromPath(listOfFiles[i]);
                stmt.execute("INSERT INTO \"ARCHIVES\" VALUES ('" + listOfTables[i] + "' ,'INITIAL')");
                listOfTablesPython = i == 0 ? "'" + listOfTables[i] + "'" : listOfTablesPython + ",'" + listOfTables[i] + "'";
            }
            stmt.close();
        }
        catch (Exception e) {
            LogFactory.writeLogEntry(this.getClass(), e.toString());
            return false;
        }
        Archive.setMaxConnections(this.parallelJobs);
        for (int i = 0; i < archives.length; ++i) {
            archives[i].start();
        }
        long start = System.nanoTime();
        System.out.println("Export load jobs: Begin loading of archives.");
        boolean alive = true;
        while (alive) {
            int alived = 0;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                LogFactory.writeLogEntry(this.getClass(), e.toString());
            }
            alive = false;
            for (int i = 0; i < archives.length; ++i) {
                if (!archives[i].isAlive()) continue;
                ++alived;
                alive = true;
            }
            Set<String> keys = Archive.getStatus().stringPropertyNames();
            int total = 0;
            int success = 0;
            int waiting = 0;
            int running = 0;
            int error = 0;
            int done = 0;
            for (String key : keys) {
                ++total;
                if ("SUCCESS".equals(Archive.getStatus().getProperty(key))) {
                    ++done;
                    ++success;
                    continue;
                }
                if ("ERROR".equals(Archive.getStatus().getProperty(key))) {
                    ++error;
                    ++done;
                    continue;
                }
                if ("INITIAL".equals(Archive.getStatus().getProperty(key)) || "RETRY".equals(Archive.getStatus().getProperty(key))) {
                    ++waiting;
                    continue;
                }
                if (!"INSERTING".equals(Archive.getStatus().getProperty(key))) continue;
                ++running;
            }
            long current = System.nanoTime();
            int percent = (int)((double)done / (double)total * 100.0);
            LogFactory.writeLogEntry(this.getClass(), "Number of active threads: " + alived + ", " + "active connections: " + Archive.getCounter());
            LogFactory.writeLogEntry(this.getClass(), "Archive status(" + percent + "%): " + Archive.getStatus().toString());
            System.out.println("Export load jobs: running " + running + ", waiting " + waiting + ", completed " + success + ", failed " + error + ", total " + total + " (" + percent + "%). Elapsed time: " + Archive.durationMin(start, current) + " minutes...");
        }
        System.out.println("Export load jobs: All archives successfully loaded.");
        this.insertStatus = Archive.getStatus();
        if (this.errorsFound(Archive.getStatus())) {
            return false;
        }
        if (this.deploymentType.equals("COMPONENT")) {
            try {
                Statement stmt = connection.createStatement();
                stmt.execute("CREATE TABLE \"FOR_HDBLCM\" (SECRET CHAR(200))");
                stmt.close();
                String sql = "INSERT INTO \"FOR_HDBLCM\" VALUES (?)";
                String xml = "<Passwords><password>" + this.maskXML(this.osUser.getPassword().get()) + "</password>" + "<system_user_password>" + this.maskXML(this.systemDatabaseSystemUser.getPassword().getValue()) + "</system_user_password>" + "</Passwords>";
                PreparedStatement pstmt = connection.prepareSQLCommand(sql);
                pstmt.setString(1, xml);
                pstmt.execute();
                pstmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LogFactory.writeLogEntry(this.getClass(), "All archives successfully loaded.");
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String encryptString = "";
        if (this.database.isEncryptTrue()) {
            encryptString = "encrypt='true', sslValidateCertificate='false', sslKeyStore='sapsrv.pse',";
            LogFactory.writeLogEntry(this.getClass(), "Database encryption enforced. Creating python script with encryption properties: " + encryptString);
        }
        String connectString = "address='localhost', port=" + systemdbPort + ", databaseName='" + this.tenantSid.getValue() + "' ";
        String script1 = "import sys\nimport os\nimport zipfile\nfrom hdbcli import dbapi\nfrom multiprocessing import Pool\nfrom zipfile import ZipFile, ZipInfo\nimport subprocess\npw = '" + connection.getConnectUser().getPassword().get() + "'\n" + "\n" + "class ZippyFile(ZipFile):\n" + "\n" + "  def extract(self, member, path=None, pwd=None):\n" + "    if not isinstance(member, ZipInfo):\n" + "      member = self.getinfo(member)\n" + "\n" + "    if path is None:\n" + "      path = os.getcwd()\n" + "\n" + "    ret_val = self._extract_member(member, path, pwd)\n" + "    attr = member.external_attr >> 16\n" + "    if attr != 0:\n" + "      os.chmod(ret_val, attr)\n" + "    return ret_val\n" + "\n" + "  if sys.version_info > (3, 5):\n" + "    def extractall(self, path=None, members=None, pwd=None):\n" + "      if members is None:\n" + "        members = self.namelist()\n" + "\n" + "      if path is None:\n" + "        path = os.getcwd()\n" + "      else:\n" + "        path = os.fspath(path)\n" + "\n" + "      for zipinfo in members:\n" + "        self.extract(zipinfo, path, pwd)\n" + "\n" + "def unzipArchive(zfile, dir):\n" + "  print (zfile + ': starting unzip.')\n" + "  target = targetdir + '/' + dir\n" + "  try:\n" + "    if os.path.exists(target):\n" + "      os.system('rm -rf ' + target)\n" + "    os.mkdir(target)\n" + "    if ( zfile.endswith('.SAR')):\n" + "      os.system('" + instanceDir + "/exe/SAPCAR -xf ' + zfile + ' -R ' +targetdir)\n" + "      print (zfile + ': unsar successful.')\n" + "    else:\n" + "      with ZippyFile(zfile) as zip_:\n" + "        zip_.extractall(targetdir)\n" + "      zip_.close()\n" + "      print (zfile + ': unzip successful.')\n" + "    return 0\n" + "  except:\n" + "    raise\n" + "\n" + "def downloadArchive(tableName):\n" + "    unzip = " + (unzip ? "True" : "False") + "\n" + "    conn = dbapi.connect(" + connectString + ", " + encryptString + "user='" + connection.getConnectUser() + "', password=pw, autocommit=True)\n" + "    for tries in range(1,2):\n" + "      print ('Downloading table \"' + tableName + '\"... (Try number' + str(tries) + ')')\n" + "      try:\n" + "        sql = 'SELECT ARCHIVE_NAME, LENGTH(ARCHIVE), ARCHIVE FROM \"' +tableName + '\"'\n" + "        cursor = conn.cursor()\n" + "        cursor.execute(sql)\n" + "        rows = cursor.fetchall()\n" + "        print (sql)\n" + "        if (len(rows) == 0):\n" + "            print ('ERROR: Table ' + tableName + ' is unexpectedly empty.')\n" + "            return -1\n" + "        for r in rows:\n" + "          a_name = r[0].rstrip()\n" + (unzip ? "          zfile=open(rootdir + '/' + a_name,'wb')\n" : "          zfile=open(targetdir + '/' + a_name,'wb')\n") + "          print ('Writing ' + a_name + ' size ' + str(r[1]) + ' to  ' + zfile.name + '...')\n" + "          zfile.write(r[2]);\n" + "          zfile.close()\n" + "        del rows\n" + "        if(unzip and unzipArchive(zfile.name, tableName)==0):\n" + "          os.remove(zfile.name)\n" + "        sql = 'DROP TABLE \"' +tableName + '\"'\n" + "        cursor.execute(sql)\n" + "        return 0\n" + "      except dbapi.ProgrammingError as exc:\n" + "        if 259 == exc.errorcode:\n" + "          print ('WARNING: Table ' + tableName + ' not found. Assuming already was downloaded.')\n" + "          return 1\n" + "        else:\n" + "          print ('ERROR: Table ' + tableName + ' download exception [' + str(exc) + ']')\n" + "      except Exception as other:\n" + "          print ('ERROR: Table ' + tableName + ' download exception [' + str(other) + ']')\n" + "    return -1\n" + "\n" + (this.action.equals("INSERT_EXTRACT") ? "def getPW():\n    conn = dbapi.connect(" + connectString + ", " + encryptString + "user='" + connection.getConnectUser() + "', password=pw, autocommit=True)\n" + "    sql = 'SELECT SECRET FROM FOR_HDBLCM'\n" + "    cursor = conn.cursor()\n" + "    cursor.execute(sql)\n" + "    row = cursor.fetchone()\n" + "    return row[0].rstrip()\n" + "\n" : "") + "rootdir = '" + this.archiveLocation + "/.zips'\n" + "targetdir = '" + this.archiveLocation + "'\n" + "if __name__ == '__main__':\n" + "  if (len(sys.argv) > 1):\n" + "    print ('Ignoring arguments...')\n" + "\n" + "  if not os.path.exists(rootdir):\n" + "    try:\n" + "      os.mkdir(rootdir)\n" + "    except:\n" + "      print ('Working directory does not exist and can not be created.')\n" + "      sys.exit(2)\n" + "\n" + "  tables = [" + listOfTablesPython + "]\n" + "  pool = Pool(1)\n" + "  result = pool.map(downloadArchive,tables)\n" + "  for r in result:\n" + "    if (r<0):\n" + "      print ('Errors exist. Check HdbCmdOut.log for more details.')\n" + "      sys.exit(1)\n" + "  print ('All files downloaded to ' + rootdir)\n" + (this.action.equals("INSERT_EXTRACT") ? "  print ('Updating components " + this.installationComponents + "')\n" + "  proc = subprocess.Popen(['" + instanceDir + "/../hdblcm/hdblcm', '--batch', '--action=update_components', '--component_root=" + this.archiveLocation + "', '--components=" + this.installationComponents + "', '--read_password_from_stdin=xml'],\n" + "         stdin=subprocess.PIPE,\n" + "         )\n" + "  proc.communicate(getPW().encode(encoding='UTF-8'))\n" : "  print ('Updating delivery unit: ' + targetdir + '/HANA_UMML.tgz')\n  proc = subprocess.Popen(['" + instanceDir + "/exe/regi', '--verbose', '--host=localhost:" + tenantPort + "', '--user=" + connection.getConnectUser() + "', '--readFromStdIn', 'import', targetdir + '/HANA_UMML.tgz'],\n" + "         stdin=subprocess.PIPE,\n" + "         )\n" + "  proc.communicate(pw.encode(encoding='UTF-8'))\n") + "print ('All files downloaded to ' + rootdir)\n" + "try:\n" + "  os.rmdir(rootdir)\n" + "except Exception as e:\n" + "  print ('Archive directory ' + rootdir + ' not deleted. [' + str(e) + ']')\n" + "sys.exit(proc.returncode)\n";
        String command = "/usr/bin/printf " + this.escapeChars(script1);
        LogFactory.writeLogEntry(this.getClass(), "Creating download script " + script_py1 + " using the connection properties: " + connectString);
        port.osExecute(command, 0, 0, script_py1, (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "Create download and unzip script failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        String command1 = instanceDir + "/HDBSettings.sh " + script_py1;
        boolean success = this.downloadAndExtractArchiveWithPython(port, command1);
        if (success || loadUser == null) {
            command = "/usr/bin/rm -rf " + this.archiveLocation;
            LogFactory.writeLogEntry(this.getClass(), "Execute: " + command);
            port.osExecute(command, 0, 0, this.tenantSid.getValue() + "_RM_SCRIPT.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        }
        if (loadUser != null) {
            this.dropLoadUser(connection, loadUser);
        }
        return success;
    }

    private String maskXML(String password) {
        return "<![CDATA[" + password + "]]>";
    }

    private DatabaseSqlUser createLoadUser(JdbcConnection connection) {
        String username = new String("SWPM20LOADER");
        DatabaseSqlUser tmpSqlUser = null;
        try {
            int i = 0;
            do {
                DatabaseSqlUserName userName = new DatabaseSqlUserName(username);
                tmpSqlUser = DatabaseSqlUserFactory.getUser(userName);
                DatabaseUser adminUser = connection.getConnectUser();
                if (!tmpSqlUser.exists(connection, this.systemUser)) {
                    DatabaseSqlUserPassword pw = PasswordFactory.generatePassword(connection, (DatabaseSystemUser)connection.getConnectUser());
                    tmpSqlUser.createNewUserAlterPassword(connection, this.systemUser, pw);
                    connection.setConnectUser(adminUser);
                    connection.executeSQLCommand("GRANT CONTENT_ADMIN TO " + tmpSqlUser.getName());
                    connection.executeSQLCommand("GRANT EXECUTE ON REPOSITORY_REST TO " + tmpSqlUser.getName() + " WITH GRANT OPTION");
                    connection.executeSQLCommand("GRANT REPO.IMPORT TO " + tmpSqlUser.getName());
                    break;
                }
                tmpSqlUser = null;
                username = "SWPM20LOADER" + ++i;
            } while (i < 10);
        }
        catch (Exception e) {
            LogFactory.writeLogEntry(this.getClass(), "Can't create load user. Load to continue with SYSTEM user.");
            tmpSqlUser = null;
        }
        return tmpSqlUser;
    }

    private void dropLoadUser(JdbcConnection connection, DatabaseSqlUser tmpUser) {
        tmpUser.dropUser(connection, this.systemUser);
    }

    private boolean errorsFound(Properties status) {
        String success = new String("SUCCESS");
        boolean result = false;
        for (String key : status.stringPropertyNames()) {
            String value = status.getProperty(key);
            if (value.equals(success)) continue;
            result = true;
            LogFactory.writeLogEntry(this.getClass(), "Archive " + key + " not loaded. Current status: " + value + ". Check file " + key + ".log for more details.");
        }
        return result;
    }

    private String getDefaultLocation(JdbcConnection connection, DatabaseSystemUser connectUser, String instanceDir, SAPControlPortType port, String param) {
        DatabaseConfiguration configuration = new DatabaseConfiguration(connection, connectUser, DatabaseConfiguration.ConfigFileName.GLOBAL_INI);
        DatabaseConfigurationSection persistenceSection = configuration.getSection("persistence");
        String location = persistenceSection.getParameterValue(param);
        if (location == null) {
            throw new HdbException("Parameter '" + DatabaseConfiguration.ConfigFileName.GLOBAL_INI.toString() + " -> " + "persistence" + " -> " + param + "' is not set.");
        }
        LogFactory.writeLogEntry(this.getClass(), "Default " + param + " location: " + location);
        if (location.contains("$(DIR_INSTANCE)")) {
            LogFactory.writeLogEntry(this.getClass(), "Instance directory: " + instanceDir);
            if (instanceDir != null) {
                location = location.replaceAll(Pattern.quote("$(DIR_INSTANCE)"), instanceDir.replaceAll(Pattern.quote("\\"), "\\\\\\\\"));
                LogFactory.writeLogEntry(this.getClass(), "Processed " + param + " location: " + location);
            }
        }
        if (this.list(port, (location = location.replaceAll(Pattern.quote("\\"), "/")) + "/DB_" + this.tenantSid.getValue())) {
            location = location + "/DB_" + this.tenantSid.getValue();
        }
        LogFactory.writeLogEntry(this.getClass(), "Calculated " + param + " to location: " + location);
        return location;
    }

    private String checkLocation(SAPControlPortType port, String location) {
        if (!this.list(port, location)) {
            this.mkdir(port, location);
        }
        LogFactory.writeLogEntry(this.getClass(), "Location for archive confirmed:  " + location);
        return location;
    }

    private String escapeChars(String script) {
        String escapedString = script.replace(" ", "\\\\ ");
        return escapedString;
    }

    public boolean insertAndExtractArchive(boolean unzip) {
        SAPControlPortType port = this.helper.getPort(this.wsdlUrl.getURL(), this.osUser.getName().get(), this.osUser.getPassword().get());
        return this.insertAndUnzipArchiveWithPython(port, unzip);
    }

    public boolean listArchive(SAPControlPortType port) {
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String command = "/bin/sh -c ls\\ " + this.archives + "";
        LogFactory.writeLogEntry(this.getClass(), "Execute: " + command);
        port.osExecute(command, 0, 0, "Archives_LIST.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "Archive list failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        LogFactory.writeLogEntry(this.getClass(), "Archive archive checked.");
        return true;
    }

    public boolean listArchive() {
        SAPControlPortType port = this.helper.getPort(this.wsdlUrl.getURL(), this.osUser.getName().get(), this.osUser.getPassword().get());
        return this.listArchive(port);
    }

    public boolean deleteArchive(SAPControlPortType port) {
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String command = "/bin/sh -c rm\\ " + this.archives + "";
        LogFactory.writeLogEntry(this.getClass(), "Execute: " + command);
        port.osExecute(command, 0, 0, "Archives_DELETE.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "Archive delete failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        LogFactory.writeLogEntry(this.getClass(), "Archive deleted.");
        return true;
    }

    public boolean deleteArchive() {
        SAPControlPortType port = this.helper.getPort(this.wsdlUrl.getURL(), this.osUser.getName().get(), this.osUser.getPassword().get());
        boolean result = false;
        if (this.listArchive(port)) {
            result = this.deleteArchive(port);
        }
        return result;
    }

    public boolean list(SAPControlPortType port, String fileOrDir) {
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String command = "/bin/sh -c ls\\ " + fileOrDir + "";
        LogFactory.writeLogEntry(this.getClass(), "Execute: " + command);
        port.osExecute(command, 0, 0, "FileOrDir_LIST.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "File or Dir list failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        LogFactory.writeLogEntry(this.getClass(), "File or Dir checked.");
        return true;
    }

    public boolean mkdir(SAPControlPortType port, String dir) {
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String command = "/bin/sh -c mkdir\\ -p\\ " + dir + "";
        LogFactory.writeLogEntry(this.getClass(), "Execute: " + command);
        port.osExecute(command, 0, 0, "mkdir.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "mkdir failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            throw new HdbException("Directory " + dir + " is not available for recovery action. Please solve any existing issue and retry.");
        }
        LogFactory.writeLogEntry(this.getClass(), "mkdir successfully executed.");
        return true;
    }

    @Override
    public void execute() {
        if (this.action.equalsIgnoreCase("INSERT_EXTRACT")) {
            LogFactory.writeLogEntry(this.getClass(), "Loading and updating HANA component(s)  " + this.archives);
            this.deploymentType = "COMPONENT";
            this.resultWriter.append(String.valueOf(this.insertAndExtractArchive(true)));
            this.resultWriter.append(this.target);
            this.resultWriter.append(this.insertStatus.toString());
        } else if (this.action.equalsIgnoreCase("INSERT_EXTRACT_DU")) {
            LogFactory.writeLogEntry(this.getClass(), "Loading and updating delivery unit " + this.archives);
            this.deploymentType = "DU";
            this.resultWriter.append(String.valueOf(this.insertAndExtractArchive(false)));
            this.resultWriter.append(this.target);
            this.resultWriter.append(this.insertStatus.toString());
        } else if (this.action.equalsIgnoreCase("INSTALL_LOCAL")) {
            LogFactory.writeLogEntry(this.getClass(), "Updating HANA component(s) locally:   " + this.installationComponents);
            this.deploymentType = "COMPONENT";
            this.resultWriter.append(String.valueOf(this.installComponentLocally()));
        } else if (this.action.equalsIgnoreCase("INSTALL_LOCAL_DU")) {
            LogFactory.writeLogEntry(this.getClass(), "Updating delivery unit locally:   " + this.installationComponents);
            this.deploymentType = "DU";
            this.resultWriter.append(String.valueOf(this.installDeliveryUnitLocally()));
        } else {
            LogFactory.writeLogEntry(this.getClass(), "No action perform on Archive " + this.archives + ".");
        }
    }

    private boolean installComponentLocally() {
        HdbLcm hdbLcm = HdbLcmFactory.getHdbLcm(this.parameters);
        this.addMandatoryParameters(hdbLcm);
        hdbLcm.updateComponent();
        return true;
    }

    private void addMandatoryParameters(HdbLcm hdbLcm) {
        EnumSet<CmdClazzParameterName> names = EnumSet.noneOf(CmdClazzParameterName.class);
        names.add(CmdClazzParameterName.DATABASE_SYSTEM_USER_PASSWORD);
        names.add(CmdClazzParameterName.INSTALLATION_COMPONENTS);
        names.add(CmdClazzParameterName.COMPONENT_ROOT);
        for (CmdClazzParameterName name : names) {
            CmdClazzParameter parameter = this.parameters.get(name);
            this.addInstallationParameter(parameter, hdbLcm);
        }
    }

    private void addInstallationParameter(CmdClazzParameter parameter, HdbLcm hdbLcm) {
        if (!(parameter instanceof InstallationParameter)) {
            throw new HdbException(parameter.getCmdClazzParameterName() + " must be instance of " + InstallationParameter.class);
        }
        hdbLcm.addInstallationParameter((InstallationParameter)((Object)parameter));
    }

    private boolean installDeliveryUnitLocally() {
        HdbUpdReg hdbUpdReg = new HdbUpdReg(this.parameters);
        hdbUpdReg.installDeliveryUnit();
        return true;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }

    public String getCachedArchiveLocation() {
        return this.archiveLocation;
    }
}

