/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.operating.system.HdbEnvironmentFactory;
import com.sap.hdb.sl.lib.operating.system.HdbEnvironmentVariableList;
import com.sap.hdb.sl.lib.operating.system.HdbEnvironmentVariableName;
import com.sap.hdb.sl.lib.operating.system.OsToolBox;
import com.sap.hdb.sl.lib.operating.system.OsToolboxFactory;
import com.sap.hdb.sl.lib.utils.GenericInstallationParameter;
import com.sap.hdb.sl.lib.utils.HdbInst;
import com.sap.hdb.sl.lib.utils.HdbInstFactory;
import com.sap.hdb.sl.lib.utils.InstallationParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.EnumSet;
import java.util.List;

public class InstallServer
implements CmdClazz {
    private CmdClazzParameterMap parameters = null;
    private HdbEnvironmentVariableList envVarList = null;
    private OsToolBox osToolBox = OsToolboxFactory.getToolbox();

    protected InstallServer() {
        this.envVarList = HdbEnvironmentFactory.getHdbVariables();
    }

    @Override
    public void execute() {
        HdbInst hdbInst = HdbInstFactory.getHdbInst(this.parameters);
        this.addMandatoryParameters(hdbInst);
        this.addOptionalParameters(hdbInst);
        if (this.envVarList.contains(HdbEnvironmentVariableName.EnvironmentVariableName.HDB_INSTALLATION_PARAMETER)) {
            List<InstallationParameter> additionalInstallParameters = GenericInstallationParameter.getParameters(this.envVarList, OsToolboxFactory.getToolbox(), CmdClazzName.INSTALL_SERVER);
            hdbInst.addInstallationParameters(additionalInstallParameters);
        }
        hdbInst.installServer();
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.parameters = parameters;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
    }

    private void addOptionalParameters(HdbInst hdbInst) {
        EnumSet<CmdClazzParameterName> names = EnumSet.noneOf(CmdClazzParameterName.class);
        names.add(CmdClazzParameterName.DATABASE_HOSTNAME);
        if (this.osToolBox.onUnix()) {
            names.add(CmdClazzParameterName.SIDADM_ID);
            names.add(CmdClazzParameterName.SIDADM_HOME);
            names.add(CmdClazzParameterName.SIDADM_LOGIN_SHELL);
            names.add(CmdClazzParameterName.SAPSYS_ID);
        } else {
            names.add(CmdClazzParameterName.WINDOWS_INSTALLATION_DRIVE);
            names.add(CmdClazzParameterName.WINDOWS_DOMAIN);
        }
        for (CmdClazzParameterName name : names) {
            if (!this.parameters.containsKey(name)) continue;
            CmdClazzParameter parameter = this.parameters.get(name);
            this.addInstallationParameter(parameter, hdbInst);
        }
    }

    private void addMandatoryParameters(HdbInst hdbInst) {
        EnumSet<CmdClazzParameterName> names = EnumSet.noneOf(CmdClazzParameterName.class);
        names.add(CmdClazzParameterName.DATABASE_SID);
        names.add(CmdClazzParameterName.INSTANCE_NUMBER);
        names.add(CmdClazzParameterName.DATABASE_SYSTEM_USER_PASSWORD);
        names.add(CmdClazzParameterName.SIDADM_PASSWORD);
        if (this.osToolBox.onUnix()) {
            names.add(CmdClazzParameterName.SAPMNT_DIRECTORY);
        }
        for (CmdClazzParameterName name : names) {
            CmdClazzParameter parameter = this.parameters.get(name);
            this.addInstallationParameter(parameter, hdbInst);
        }
    }

    private void addInstallationParameter(CmdClazzParameter parameter, HdbInst hdbInst) {
        if (!(parameter instanceof InstallationParameter)) {
            throw new HdbException(parameter.getCmdClazzParameterName() + " must be instance of " + InstallationParameter.class);
        }
        hdbInst.addInstallationParameter((InstallationParameter)((Object)parameter));
    }
}

