/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseConnectUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.List;

public class IsConnectPossible
extends BatchExecutionBase
implements CmdClazz {
    private ResultFileWriter resultWriter = null;
    private Database database = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private DatabaseUser connectUser = null;
    public static String CONNECT_IS_POSSIBLE = "CONNECT_IS_POSSIBLE";

    protected IsConnectPossible() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.connectUser = DatabaseConnectUserFactory.getConnectUser(parameters);
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        boolean connectIsPossible = false;
        Result result = null;
        String message = "";
        String versionString = "";
        String mode = "";
        String systemID = "";
        String dbsid = "";
        String instno = "";
        try {
            this.connection.setUserAndConnect(this.connectUser);
            if (!this.database.isSystemDB() && this.connectUser instanceof DatabaseSystemUser) {
                ((DatabaseSystemUser)this.connectUser).adminUserOK(this.connection);
            }
            this.connection.executeSQLCommandNoReslt("SELECT CURRENT_USER FROM DUMMY");
            connectIsPossible = true;
            result = Result.SUCCESS;
            message = "Connect was successful!";
            List<String> version = this.connection.executeSQLCommand("SELECT \"VALUE\" FROM \"PUBLIC\".\"M_SYSTEM_OVERVIEW\" WHERE \"SECTION\" = 'System' AND \"NAME\" = 'Version'");
            versionString = version.size() == 0 ? "unknown" : version.get(0);
            mode = this.connection.getDatabaseMode().toString();
            systemID = this.database.getSystem_id(this.connection, this.connectUser);
            Sid expectedName = this.database.getSid();
            Sid actualName = this.database.getSid(this.connection, this.connectUser);
            if (!"".equals(expectedName.get()) && !actualName.equals(expectedName)) {
                result = Result.WRONG_SID;
                message = "Wrong database ID! Given: " + expectedName + " Found: " + actualName;
            }
            dbsid = actualName.getValue();
            List<String> instnos = this.connection.executeSQLCommand("SELECT \"VALUE\" FROM \"PUBLIC\".\"M_SYSTEM_OVERVIEW\" WHERE \"SECTION\" = 'System' AND \"NAME\" = 'Instance Number'");
            if (instnos.size() > 0) {
                instno = instnos.get(0);
            }
        }
        catch (HdbException e) {
            int errorCode = this.connection.getErrorCode();
            message = e.getMessage();
            if (errorCode == 0) {
                if (message.contains("-709")) {
                    errorCode = -709;
                } else if (message.contains("-813")) {
                    errorCode = -813;
                } else if (e.testDatabaseNotExists()) {
                    errorCode = 2;
                } else {
                    if (e.testInvalidSystemId()) {
                        throw e;
                    }
                    if (message.contains("INVALID_ADMIN_USER")) {
                        result = Result.INVALID_ADMIN_USER;
                        message = message.substring(message.indexOf("]") + 1);
                    } else {
                        try {
                            String returnCode = message.substring(message.indexOf("[") + 1, message.indexOf("]"));
                            errorCode = Integer.parseInt(returnCode);
                        }
                        catch (Exception e1) {
                            LogFactory.writeLogEntry(this.getClass(), message);
                            errorCode = -1;
                        }
                    }
                }
            }
            switch (errorCode) {
                case 2: {
                    result = Result.NON_EXISTENT_TENANT;
                    break;
                }
                case 10: {
                    result = Result.INVALID_USER_PASSWORD;
                    break;
                }
                case 414: {
                    result = Result.CHANGE_PASSWORD;
                    break;
                }
                case 437: {
                    result = Result.LICENSE_EXPIRED;
                    break;
                }
                case -709: {
                    result = Result.UNKNOWN_HOST;
                    break;
                }
                case -813: {
                    result = Result.CONNECTION_REFUSED;
                    break;
                }
                default: {
                    if (result != null) break;
                    result = Result.FAILURE;
                }
            }
            LogFactory.writeLogExceptionEntry(this.getClass(), result.toString(), message);
        }
        if (null != this.resultWriter) {
            this.resultWriter.append(String.valueOf(connectIsPossible));
            this.resultWriter.append(result.toString());
            this.resultWriter.append(versionString);
            this.resultWriter.append(message);
            this.resultWriter.append(mode);
            this.resultWriter.append(systemID);
            this.resultWriter.append(dbsid);
            this.resultWriter.append(instno);
        }
        if (null != this.resultKeeper) {
            this.resultKeeper.addResult(CONNECT_IS_POSSIBLE, String.valueOf(connectIsPossible));
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }

    public void setJdbcConnection(JdbcConnection connection) {
        this.connection = connection;
    }

    public static enum Result {
        SUCCESS,
        CHANGE_PASSWORD,
        FAILURE,
        UNKNOWN_HOST,
        CONNECTION_REFUSED,
        INVALID_USER_PASSWORD,
        INVALID_ADMIN_USER,
        WRONG_SID,
        NON_EXISTENT_TENANT,
        LICENSE_EXPIRED;

    }
}

