/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseTraceFile;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;

public class IsDatabaseContentBasedOnRestore
implements CmdClazz {
    private ResultFileWriter resultFileWriter;
    private JdbcDriver jdbcDriver = null;
    private DatabaseSqlUser sqlUser = null;
    private DatabaseSystemUser systemUser = null;
    private Database database = null;
    private JdbcConnection testConnection = null;

    protected IsDatabaseContentBasedOnRestore() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        if (null == this.testConnection) {
            this.testConnection = connection;
        }
        String resultLine = "false";
        String restoreResultLine = "Latest restore time: No restore found.";
        String userResultLine = "Create time of user " + this.sqlUser.getName().get() + ": User does not exist!";
        if (this.sqlUser.exists(connection, this.systemUser)) {
            Date createDateUser = this.sqlUser.getCreateDate(connection, this.systemUser);
            userResultLine = "Create time of user " + this.sqlUser.getName().get() + ": " + createDateUser;
            DatabaseTraceFile backupLog = new DatabaseTraceFile();
            Set<String> entries = backupLog.getTraceEntries(this.testConnection, this.systemUser, DatabaseTraceFile.FileName.BACKUP_LOG, "RECOVERY RECOVER DATA finished successfully");
            if (entries.size() > 0) {
                Date latestRestoreDate = null;
                for (String entry : entries) {
                    GregorianCalendar restoreDate;
                    String timeStamp = entry.split("\\+")[0].trim();
                    String[] dateTime = timeStamp.split("T");
                    if (dateTime.length != 2) continue;
                    String date = dateTime[0];
                    String[] yearMonthDay = date.split("-");
                    String time = dateTime[1];
                    String[] hourMinuteSecond = time.split(":");
                    if (yearMonthDay.length != 3 || hourMinuteSecond.length != 3 || null == (restoreDate = this.getRestoreDate(yearMonthDay, hourMinuteSecond))) continue;
                    if (null == latestRestoreDate || latestRestoreDate.compareTo(restoreDate.getTime()) < 0) {
                        latestRestoreDate = restoreDate.getTime();
                    }
                    restoreResultLine = "Latest restore was done at: " + latestRestoreDate;
                    if (createDateUser.compareTo(latestRestoreDate) < 0) {
                        resultLine = String.valueOf(true);
                        continue;
                    }
                    resultLine = String.valueOf(false);
                }
            }
        }
        LogFactory.writeLogEntry(this.getClass(), restoreResultLine);
        LogFactory.writeLogEntry(this.getClass(), userResultLine);
        LogFactory.writeLogEntry(this.getClass(), "Result is: " + resultLine);
        if (resultLine.equals("true")) {
            LogFactory.writeLogEntry(this.getClass(), "Database content is based on a restore.");
        } else {
            LogFactory.writeLogEntry(this.getClass(), "Database content is not based on a restore.");
        }
        this.resultFileWriter.append(resultLine);
        this.resultFileWriter.append(restoreResultLine);
        this.resultFileWriter.append(userResultLine);
    }

    private GregorianCalendar getRestoreDate(String[] yearMonthDay, String[] hourMinuteSecond) {
        GregorianCalendar restoreDate;
        try {
            restoreDate = new GregorianCalendar(Integer.valueOf(yearMonthDay[0]), Integer.valueOf(yearMonthDay[1]) - 1, Integer.valueOf(yearMonthDay[2]), Integer.valueOf(hourMinuteSecond[0]), Integer.valueOf(hourMinuteSecond[1]), Integer.valueOf(hourMinuteSecond[2]));
        }
        catch (Exception e) {
            restoreDate = null;
        }
        return restoreDate;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }

    public void setJdbcConnection(JdbcConnection connection) {
        this.testConnection = connection;
    }
}

