/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.List;

public class IsDeclusteringComplete
implements CmdClazz {
    private Database database = null;
    private JdbcConnection connection = null;
    private JdbcDriver jdbcDriver = null;
    private DatabaseSqlUser sqlUser = null;
    private ResultFileWriter resultWriter = null;

    protected IsDeclusteringComplete() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        this.connection.setConnectUser(this.sqlUser);
        String query = "SELECT COUNT(TABNAME) FROM DD02L WHERE TABCLASS = 'CLUSTER'";
        List<String> result = this.connection.executeSQLCommand(query);
        if (result.get(0).equals("0")) {
            this.resultWriter.append(Boolean.TRUE.toString());
        } else {
            this.resultWriter.append(Boolean.FALSE.toString());
            this.resultWriter.append(String.valueOf("SQL Query '" + query + "' for user " + this.sqlUser + " returned: " + result.get(0) + " Check OSS-note 1914220 for further details!"));
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }
}

