/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.password.DatabaseSqlUserPassword;
import com.sap.hdb.sl.lib.user.password.DatabaseSystemUserPassword;
import com.sap.hdb.sl.lib.user.password.HdbPassword;
import com.sap.hdb.sl.lib.user.password.Password;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.Map;

public class IsValidPassword
implements CmdClazz {
    private CmdClazzParameterMap parameters = null;
    private ResultFileWriter resultWriter = null;

    protected IsValidPassword() {
    }

    @Override
    public void execute() {
        boolean systemUserPasswordSpecified = false;
        boolean sqlUserPasswordSpecified = false;
        boolean otherUserPasswordSpecified = false;
        for (Map.Entry e : this.parameters.entrySet()) {
            CmdClazzParameter parameter = (CmdClazzParameter)e.getValue();
            if (!(parameter instanceof Password)) continue;
            Password password = (Password)((Object)parameter);
            if (password instanceof DatabaseSystemUserPassword) {
                systemUserPasswordSpecified = true;
                continue;
            }
            if (password instanceof DatabaseSqlUserPassword) {
                sqlUserPasswordSpecified = true;
                continue;
            }
            otherUserPasswordSpecified = true;
        }
        if (!(systemUserPasswordSpecified || sqlUserPasswordSpecified || otherUserPasswordSpecified)) {
            throw new HdbException("No CmdClazzParameter of type Password found in CmdClazzParameterMap!");
        }
        boolean valid = false;
        Password password = null;
        boolean passwordChecked = false;
        for (Map.Entry e : this.parameters.entrySet()) {
            CmdClazzParameter parameter = (CmdClazzParameter)e.getValue();
            if (!(parameter instanceof Password) || passwordChecked) continue;
            password = (Password)((Object)parameter);
            if (sqlUserPasswordSpecified && password instanceof DatabaseSqlUserPassword) {
                valid = ((HdbPassword)password).isValid(this.parameters);
                passwordChecked = true;
                continue;
            }
            if (systemUserPasswordSpecified && !sqlUserPasswordSpecified && password instanceof DatabaseSystemUserPassword) {
                valid = ((HdbPassword)password).isValid(this.parameters);
                passwordChecked = true;
                continue;
            }
            if (!otherUserPasswordSpecified) continue;
            valid = password.isValid();
            passwordChecked = true;
        }
        if (valid) {
            this.resultWriter.append(String.valueOf(true));
        } else {
            this.resultWriter.append(String.valueOf(false));
            this.resultWriter.append("The password is invalid: " + password.getRuleDescription());
        }
        LogFactory.writeLogEntry(this.getClass(), "Password valid: " + valid);
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.parameters = parameters;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }
}

