/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.SchemaName;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.Map;

public class IsValidSchemaName
implements CmdClazz {
    private CmdClazzParameterMap parameters = null;
    private ResultFileWriter resultWriter = null;
    private int minimumLength = 3;

    protected IsValidSchemaName() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.parameters = parameters;
    }

    @Override
    public void execute() {
        SchemaName schemaName = null;
        for (Map.Entry e : this.parameters.entrySet()) {
            CmdClazzParameter parameter = (CmdClazzParameter)e.getValue();
            if (!(parameter instanceof SchemaName)) continue;
            schemaName = (SchemaName)parameter;
            break;
        }
        if (null == schemaName) {
            throw new HdbException("No CmdClazzParameter of type SchemaName found in CmdClazzParameterMap!");
        }
        if (schemaName.isValid(this.minimumLength)) {
            this.resultWriter.append(String.valueOf(true));
        } else {
            this.resultWriter.append(String.valueOf(false));
            this.resultWriter.append("The schema name must only contain letters and numbers. It must be at least " + this.minimumLength + " and at most 30 characters long." + " It must not be SYS or SYSTEM, nor one of the following reserved SQL Keywords: " + Sid.RESERVED_KEYWORDS + " or one of the following SIDS: " + Sid.RESERVED_SIDS + ".");
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }
}

