/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.memory.MergeMonitor;
import com.sap.hdb.sl.lib.memory.ResourcesData;
import com.sap.hdb.sl.lib.user.DatabaseConnectUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

public class MergeDelta
implements CmdClazz {
    private Database database;
    private DatabaseUser dbUser;
    private JdbcDriver jdbcDriver;
    private JdbcConnection connection;
    private ResultFileWriter resultFileWriter;

    protected MergeDelta() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.dbUser = DatabaseConnectUserFactory.getConnectUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
            this.connection.setConnectUser(this.dbUser);
        }
        Connection conn = this.connection.getConnection();
        MergeMonitor merger = new MergeMonitor();
        try {
            ArrayList<ResourcesData> resourceDataList = merger.getCurrentResourcesDataList(this.connection);
            boolean performAction = merger.performAction(resourceDataList);
            ResourcesData resourcesData = merger.getCurrentResourcesData();
            merger.findTablesInDelta(conn, resourcesData);
            while (performAction && merger.getAllTableDataList().size() > 0) {
                merger.mergeTablesInDelta(conn, resourcesData.getMergeTokens());
                resourceDataList = merger.getCurrentResourcesDataList(this.connection);
                performAction = merger.performAction(resourceDataList);
                resourcesData = merger.getCurrentResourcesData();
            }
        }
        catch (SQLException e) {
            LogFactory.writeLogEntry(this.getClass(), "Could not execute merge delta " + e.getMessage());
        }
        finally {
            this.connection.closeConnection();
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

