/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.abap.BasisUtils;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionPool;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.HdbVersion;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.mem.HdbsllibMem;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class NSEOldPersistence
implements CmdClazz {
    private Database database = null;
    private DatabaseSqlUser sqlUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private JdbcConnectionPool pool = null;
    private ResultFileWriter resultFileWriter;
    private List<TableRecordCount> tablesRecords = new ArrayList<TableRecordCount>();
    private List<TableRecordCount> tablesZeroRecords = new ArrayList<TableRecordCount>();
    private boolean createSqlFile = false;
    Integer parprocs = null;
    private boolean dd09l_only = false;
    private boolean migrate = false;
    private String addOptions = null;
    private static String CHECK = "CHECK";
    private static String SHD_EXECUTE = "SHD_EXECUTE";
    private static String MIGRATE = "MIGRATE";
    String countStarSql = "SELECT COUNT(*) FROM \"";
    String mergeTableSql = "MERGE DELTA OF \"";
    List<Future> tasks = new ArrayList<Future>();
    String oldPersistenceTablesSql = "SELECT TABLE_NAME, SUM(RECORD_COUNT) FROM SYS.M_CS_TABLES AS M_CS_TAB WHERE SCHEMA_NAME = CURRENT_SCHEMA AND TABLE_NAME IN /*dd09l_addition*/ ( SELECT DISTINCT TABLE_NAME FROM SYS.M_CS_COLUMNS_PERSISTENCE WHERE SCHEMA_NAME = M_CS_TAB.SCHEMA_NAME AND PERSISTENCE_TYPE in ('VIRTUAL_FILE', 'VIRTUAL_PAGED') ) AND TABLE_NAME NOT IN ( SELECT TABLE_NAME FROM SYS.TABLES WHERE SCHEMA_NAME = M_CS_TAB.SCHEMA_NAME AND SUBSTR(PARTITION_SPEC, 1, 20) =  'RANGE[TIME SELECTION' ) GROUP BY TABLE_NAME";
    String HANA2Rev10TimestampSql = "SELECT MIN(INSTALL_TIME) FROM SYS.M_DATABASE_HISTORY WHERE  VERSION >= '2.00.010.00.0000000000'";
    String HANA2Rev10HistorySql = "SELECT INSTALL_TIME FROM SYS.M_DATABASE_HISTORY WHERE  VERSION < '2.00.010.00.0000000000'";
    String tablesCreatedBeforeHANA2Rev10Sql = "SELECT TABLE_NAME, SUM(RECORD_COUNT) FROM SYS.M_CS_TABLES AS M_CS_TAB  WHERE SCHEMA_NAME = CURRENT_SCHEMA AND TABLE_NAME NOT IN  ( SELECT DISTINCT TABLE_NAME FROM SYS.M_CS_COLUMNS_PERSISTENCE WHERE SCHEMA_NAME = M_CS_TAB.SCHEMA_NAME ) AND  CREATE_TIME  < ( " + this.HANA2Rev10TimestampSql + " )  AND " + " TABLE_NAME NOT IN " + " ( SELECT TABLE_NAME FROM SYS.TABLES WHERE SCHEMA_NAME = M_CS_TAB.SCHEMA_NAME AND " + "  SUBSTR(PARTITION_SPEC, 1, 20) =  'RANGE[TIME SELECTION' ) " + " GROUP BY TABLE_NAME";
    String dd09l_addition = "( SELECT TABNAME AS TABLE_NAME FROM \"DD09L~\" WHERE LOAD_UNIT in ('P', 'Q') ) AND TABLE_NAME IN ";

    protected NSEOldPersistence() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        if (parameters.containsKey(CmdClazzParameterName.ADD_OPTIONS)) {
            this.addOptions = parameters.get(CmdClazzParameterName.ADD_OPTIONS).getValue();
        }
    }

    @Override
    public void execute() {
        HdbsllibMem mem = HdbsllibMem.getInstance();
        String memParams = null;
        if (null != mem) {
            memParams = mem.read("[NSE]");
        }
        if (null != memParams && (memParams.equalsIgnoreCase("false") || memParams.equalsIgnoreCase("no") || memParams.equalsIgnoreCase("0"))) {
            LogFactory.writeLogEntry(this.getClass(), "found [NSE]" + memParams + ". Stop NSE");
            return;
        }
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        this.connection.setConnectUser(this.sqlUser);
        this.unsetNseConfiguration(this.connection, this.sqlUser);
        if (null != this.addOptions) {
            this.readParams(this.addOptions);
        }
        if (null != memParams) {
            this.readParams(memParams);
        }
        int jobs = this.determineJobs();
        if (this.needsMigration()) {
            this.findOldPersistenceTables();
            if (this.tablesZeroRecords.size() > 0) {
                LogFactory.writeLogEntry(this.getClass(), "Found " + this.tablesZeroRecords.size() + " empty tables in old persistence format. Will migrate these tables.");
                this.mergeTablesParalell(jobs, this.tablesZeroRecords);
            }
        }
        if (0 == this.tablesRecords.size()) {
            this.resultFileWriter.append("true");
            return;
        }
        LogFactory.writeLogEntry(this.getClass(), "Found " + this.tablesRecords.size() + " tables in old persistence format");
        if (this.createSqlFile) {
            this.createSqlFile();
            this.resultFileWriter.append("false");
            return;
        }
        this.mergeTablesParalell(jobs, this.tablesRecords);
        this.resultFileWriter.append("true");
    }

    private void unsetNseConfiguration(JdbcConnection connection, DatabaseUser user) {
        LogFactory.writeLogEntry(this.getClass(), "Checking enable_native_storage_extension configuration...");
        DatabaseConfiguration config = new DatabaseConfiguration(connection, user, DatabaseConfiguration.ConfigFileName.INDEXSERVER_INI);
        DatabaseConfigurationSection section = config.getSection("nseconfig");
        String nse_config = section.getParameterValue("enable_native_storage_extension");
        if (null != nse_config && nse_config.equalsIgnoreCase("false")) {
            LogFactory.writeLogEntry(this.getClass(), "Found parameter enable_native_storage_extension: " + nse_config);
            section.unsetParameter("enable_native_storage_extension");
        }
    }

    private void createSqlFile() {
        PrintWriter pw;
        String fileName = "oldPersistenceTables.sql";
        File file = this.createFile(fileName);
        try {
            pw = new PrintWriter(new FileWriter(file, false));
        }
        catch (FileNotFoundException e) {
            throw new HdbException(e.getMessage());
        }
        catch (IOException e) {
            throw new HdbException(e.getMessage());
        }
        for (TableRecordCount table : this.tablesRecords) {
            StringBuilder sb = new StringBuilder("-- migrate table " + table.getTable()).append(" with ").append(table.getRecordCount()).append(" records.");
            pw.println(sb.toString());
            sb = new StringBuilder(this.countStarSql).append(table.getTable()).append("\";");
            pw.println(sb.toString());
            sb = new StringBuilder(this.mergeTableSql).append(table.getTable()).append("\" FORCE REBUILD;");
            pw.println(sb.toString());
            sb = new StringBuilder("UNLOAD \"").append(table.getTable()).append("\";");
            pw.println(sb.toString());
            pw.flush();
        }
        pw.close();
        LogFactory.writeLogEntry(this.getClass(), "Sql script " + file.getAbsolutePath() + " generated.");
    }

    private File createFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            try {
                boolean created = file.createNewFile();
                if (!created) {
                    throw new HdbException(file + " could not be created!");
                }
            }
            catch (IOException e) {
                throw new HdbException(e.getMessage());
            }
        }
        return file;
    }

    private void readParams(String params) {
        String[] splits = params.split(",");
        String parProcsParam = "";
        for (String part : splits) {
            part.trim();
            if (part.startsWith("parprocs=")) {
                parProcsParam = part.substring(part.indexOf("=") + 1);
            }
            if (part.equalsIgnoreCase(CHECK)) {
                this.createSqlFile = true;
            }
            if (part.equalsIgnoreCase(SHD_EXECUTE)) {
                this.dd09l_only = true;
            }
            if (part.equalsIgnoreCase(MIGRATE)) {
                this.migrate = true;
                this.createSqlFile = false;
            }
            LogFactory.writeLogEntry(this.getClass(), "Received option: " + part);
        }
        if (parProcsParam.length() > 0) {
            try {
                this.parprocs = Integer.parseInt(parProcsParam);
            }
            catch (NumberFormatException e) {
                LogFactory.writeLogEntry(this.getClass(), parProcsParam + " is not a number. " + e.getMessage());
            }
        }
    }

    private int determineJobs() {
        int jobs = 0;
        jobs = null == this.parprocs ? this.determineCoresNumberOnHana() : this.parprocs.intValue();
        return jobs;
    }

    private boolean needsMigration() {
        boolean needsMigration = true;
        String dbVersionSql = "SELECT VERSION FROM SYS.M_DATABASE";
        List<String> versions = this.connection.executeSQLCommand(dbVersionSql);
        String currentVersion = versions.get(0);
        if (!this.isSP4orHigher(currentVersion)) {
            return false;
        }
        return needsMigration;
    }

    private boolean isSP4orHigher(String currentVersion) {
        HdbVersion version = new HdbVersion(currentVersion);
        int major = version.getMajorVersion();
        int revision = version.getRevision();
        return major == 2 && revision >= 40;
    }

    private void mergeTables(List<TableRecordCount> tablesToMigrate) {
        for (TableRecordCount table : tablesToMigrate) {
            this.connection.executeSQLCommand(this.countStarSql + table.getTable() + "\" WITH HINT(IGNORE_PLAN_CACHE)");
            this.connection.executeSQLCommand(this.mergeTableSql + table.getTable() + "\" FORCE REBUILD");
            this.connection.executeSQLCommand("UNLOAD \"" + table.getTable() + "\"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void mergeTablesParalell(int jobs, List<TableRecordCount> tablesToMigrate) {
        Object worker;
        int i;
        if (jobs < 2) {
            this.mergeTables(tablesToMigrate);
            return;
        }
        if (tablesToMigrate.size() < jobs) {
            jobs = tablesToMigrate.size();
        }
        LogFactory.writeLogEntry(this.getClass(), "Will use " + jobs + " jobs for migration. " + "Number of migration jobs can be set: [NSE]parprocs=10 -> in tmp/HdbsllibMem.txt and restart the SUM phase");
        ExecutorService executorService = Executors.newFixedThreadPool(jobs);
        long start = System.currentTimeMillis();
        LogFactory.writeLogEntry(this.getClass(), "Start migration at " + start);
        ArrayList chunks = new ArrayList();
        HashMap chunksMap = new HashMap(jobs);
        for (i = 0; i < jobs; ++i) {
            chunks.add(new ArrayList());
            chunksMap.put(i, new ArrayList());
        }
        for (i = 0; i < tablesToMigrate.size(); ++i) {
            ((List)chunksMap.get(i % jobs)).add(tablesToMigrate.get(i));
        }
        this.pool = new JdbcConnectionPool(this.jdbcDriver, this.database, jobs);
        for (i = 0; i < jobs; ++i) {
            class MergeThread
            implements Runnable {
                List<TableRecordCount> tablesToMerge;

                MergeThread(List<TableRecordCount> list) {
                    this.tablesToMerge = list;
                }

                @Override
                public void run() {
                    JdbcConnection conn = NSEOldPersistence.this.pool.getConnection();
                    conn.setConnectUser(NSEOldPersistence.this.sqlUser);
                    for (TableRecordCount table : this.tablesToMerge) {
                        if (table.getRecordCount() < 2000000000) {
                            try {
                                conn.executeSQLCommand(NSEOldPersistence.this.countStarSql + table.getTable() + "\" WITH HINT(IGNORE_PLAN_CACHE)");
                                conn.executeSQLCommand(NSEOldPersistence.this.mergeTableSql + table.getTable() + "\" FORCE REBUILD");
                                conn.executeSQLCommand("UNLOAD \"" + table.getTable() + "\"");
                            }
                            catch (Exception e) {
                                LogFactory.writeLogEntry(this.getClass(), "Error during migration of table " + table.getTable() + " " + e.toString());
                            }
                            continue;
                        }
                        if (null == table || null == table.getTable()) continue;
                        LogFactory.writeLogEntry(this.getClass(), "Skip table " + table.getTable() + " with record count " + table.getRecordCount() + " rows!");
                    }
                    NSEOldPersistence.this.pool.releaseConnection(conn);
                }
            }
            worker = new MergeThread((List)chunksMap.get(i));
            Future<?> future = executorService.submit((Runnable)worker);
            this.tasks.add(future);
        }
        int waitTime = 1000;
        worker = this;
        synchronized (worker) {
            while (!this.allTasksCompleted()) {
                try {
                    this.wait(waitTime);
                    if (waitTime >= 20000) continue;
                    waitTime += 1000;
                }
                catch (InterruptedException e) {
                    LogFactory.writeLogEntry(this.getClass(), "Error while waiting all tasks to complete " + e.getMessage());
                }
            }
        }
        try {
            executorService.awaitTermination(800L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e1) {
            executorService.shutdownNow();
        }
        this.pool.shutdown();
        executorService.shutdown();
        long finish = System.currentTimeMillis();
        long timeElapsed = finish - start;
        LogFactory.writeLogEntry(this.getClass(), "End migration at " + finish);
        LogFactory.writeLogEntry(this.getClass(), "Elapsed time for migration: " + timeElapsed / 1000L + " seconds.");
    }

    private boolean allTasksCompleted() {
        for (Future task : this.tasks) {
            if (task.isDone()) continue;
            return false;
        }
        return true;
    }

    private boolean cancelAllTasks() {
        for (Future task : this.tasks) {
            if (task.isDone()) continue;
            task.cancel(true);
        }
        return true;
    }

    private int determineCoresNumberOnHana() {
        int res = 10;
        int core = 0;
        ArrayList<Integer> threadsList = new ArrayList<Integer>();
        String cpuSql = "select value from SYS.M_HOST_INFORMATION where key in ('cpu_cores')";
        List<String> cores = this.connection.executeSQLCommand(cpuSql);
        for (String number : cores) {
            try {
                core = new Integer(number);
                threadsList.add(core);
            }
            catch (NumberFormatException e) {
                LogFactory.writeLogEntry(this.getClass(), number + " is not a number. " + e.getMessage());
            }
        }
        int sum = 0;
        for (Integer threads : threadsList) {
            sum += threads.intValue();
        }
        res = sum / threadsList.size();
        if (res > 40) {
            res = 40;
        }
        return res;
    }

    private void findOldPersistenceTables() {
        if (this.dd09l_only) {
            this.findOldPersistenceTablesWithLoadUnitP();
            return;
        }
        this.queryDatabase(this.oldPersistenceTablesSql);
        List<String> result = this.connection.executeSQLCommand(this.HANA2Rev10HistorySql);
        if (result.size() > 0) {
            this.queryDatabase(this.tablesCreatedBeforeHANA2Rev10Sql);
        }
    }

    private void queryDatabase(String sql) {
        ResultSet resultSet = null;
        try {
            Statement stmt = this.connection.getConnection().createStatement();
            LogFactory.writeLogEntry(this.getClass(), "Run SQL command: " + sql);
            if (stmt.execute(sql)) {
                resultSet = stmt.getResultSet();
                if (resultSet.next()) {
                    do {
                        String table = resultSet.getString(1);
                        int count = resultSet.getInt(2);
                        TableRecordCount tableRec = new TableRecordCount(table, count);
                        if (0 == count) {
                            this.tablesZeroRecords.add(tableRec);
                            continue;
                        }
                        this.tablesRecords.add(tableRec);
                    } while (resultSet.next());
                }
                resultSet.close();
            }
            stmt.close();
        }
        catch (SQLException sqle) {
            String message = "Error during execution of SQL command: " + sql + " " + sqle.getMessage();
            LogFactory.writeLogEntry(this.getClass(), message);
            this.connection.closeConnection();
            throw new HdbException(message);
        }
        catch (Exception e) {
            LogFactory.writeLogEntry(this.getClass(), "Could not find tables in old persistence format. " + e.getMessage());
        }
    }

    private void findOldPersistenceTablesWithLoadUnitP() {
        if (!BasisUtils.tableHasField("DD09L~", "LOAD_UNIT", this.connection)) {
            return;
        }
        try {
            this.queryDatabase(this.oldPersistenceTablesSql.replace("/*dd09l_addition*/", this.dd09l_addition));
        }
        catch (Exception e) {
            LogFactory.writeLogEntry(this.getClass(), "Could not find tables in old persistence format which have LOAD_UNIT = 'P' in DD09L~. " + e.getMessage());
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }

    class TableRecordCount {
        String table;
        int recordCount;

        public TableRecordCount(String table, int recordCount) {
            this.table = table;
            this.recordCount = recordCount;
        }

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public int getRecordCount() {
            return this.recordCount;
        }

        public void setRecordCount(int recordCount) {
            this.recordCount = recordCount;
        }
    }
}

