/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseReorgCheckType;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.IOUtils;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;

public class PerformDatabaseReorgCheck
implements CmdClazz {
    private ResultFileWriter resultFileWriter;
    private Database database;
    private DatabaseSystemUser systemUser;
    private JdbcDriver jdbcDriver;
    private JdbcConnection connection;
    private DatabaseSqlUser sqlUser;
    private DatabaseReorgCheckType.CheckType checkType;

    protected PerformDatabaseReorgCheck() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        this.checkType = ((DatabaseReorgCheckType)parameters.get(CmdClazzParameterName.DATABASE_REORG_CHECK_TYPE)).getCheckType();
    }

    @Override
    public void execute() {
        ResultSet r;
        PreparedStatement statement;
        StringBuilder output;
        boolean success;
        Connection conn;
        block12: {
            if (null == this.connection) {
                this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
                this.connection.setConnectUser(this.systemUser);
            }
            conn = this.connection.getConnection();
            success = true;
            output = new StringBuilder();
            statement = null;
            r = null;
            try {
                int count;
                statement = conn.prepareStatement("SELECT COUNT(*) FROM PROCEDURES WHERE SCHEMA_NAME='SYSTEM' AND PROCEDURE_NAME=?");
                statement.setString(1, this.checkType.getProcedureName().toUpperCase(Locale.ENGLISH));
                r = statement.executeQuery();
                if (!r.next() || (count = r.getInt(1)) == 1) break block12;
                success = false;
                output.append("\"SWPM001\",\"EX001\",\"ERROR\",\"1\",\"The procedure '").append(this.checkType.getProcedureName().toUpperCase(Locale.ENGLISH)).append("' doesn't exist in the database. Please check SAP note 1958346.\"");
                this.resultFileWriter.append(String.valueOf(success));
                this.resultFileWriter.append(output.toString());
            }
            catch (SQLException e) {
                try {
                    throw new HdbException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(r);
                    IOUtils.closeQuietly(statement);
                    IOUtils.closeQuietly(conn);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(r);
            IOUtils.closeQuietly(statement);
            IOUtils.closeQuietly(conn);
            return;
        }
        IOUtils.closeQuietly(r);
        IOUtils.closeQuietly(statement);
        IOUtils.closeQuietly(conn);
        this.connection.createConnection();
        conn = this.connection.getConnection();
        output = new StringBuilder();
        CallableStatement call = null;
        ResultSet rs = null;
        try {
            call = conn.prepareCall("CALL " + this.checkType.getProcedureName() + "(?,?)");
            call.setString(1, this.sqlUser.getName().get());
            call.registerOutParameter(1, 2002, "tt_check_result");
            call.executeUpdate();
            rs = call.getResultSet();
            while (rs.next()) {
                String version = rs.getString(1);
                String check = rs.getString(2);
                String status = rs.getString(3);
                int msg_no = rs.getInt(4);
                String description = rs.getString(5);
                LogFactory.writeLogEntry(this.getClass(), version + " | " + check + " | " + status + " | " + msg_no + " | " + description);
                if (!"OK".equals(status)) {
                    success = false;
                }
                if (output.length() > 0) {
                    output.append("\n");
                }
                output.append("\"").append(version.replaceAll("\"", "\"\"")).append("\",\"").append(check.replaceAll("\"", "\"\"")).append("\",\"").append(status.replaceAll("\"", "\"\"")).append("\",\"").append(msg_no).append("\",\"").append(description.replaceAll("\"", "\"\"")).append("\"");
            }
        }
        catch (SQLException e) {
            try {
                throw new HdbException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(rs);
                IOUtils.closeQuietly(call);
                IOUtils.closeQuietly(conn);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(rs);
        IOUtils.closeQuietly(call);
        IOUtils.closeQuietly(conn);
        this.resultFileWriter.append(String.valueOf(success));
        this.resultFileWriter.append(output.toString());
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

