/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseCatalogObject;
import com.sap.hdb.sl.lib.instance.DatabaseTable;
import com.sap.hdb.sl.lib.instance.DatabaseView;
import com.sap.hdb.sl.lib.instance.DatabaseVolume;
import com.sap.hdb.sl.lib.instance.DatabaseVolumeFactory;
import com.sap.hdb.sl.lib.instance.FileParameter;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.IOUtils;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.regex.Pattern;

public class ProcessDatabaseReorgParameterFile
implements CmdClazz {
    public static final String SYS = "SYS";
    public static final String SYS_RT = "_SYS_RT";
    public static final String PUBLIC = "PUBLIC";
    public static final String TABLE_PLACEMENT = "TABLE_PLACEMENT";
    private static final String PLACEHOLDER = "$$PLACEHOLDER";
    private static final String PLACEHOLDER_LC = "$$LIVECACHE_PLACEHOLDER";
    private static final String INITIAL_PARTITIONS = "INITIAL_PARTITIONS";
    private static final String INITAL_PARTITIONS_NO_I = "INITAL_PARTITIONS";
    private static final String END_HEADER = "[END HEADER]";
    private static final String BEGIN_HEADER = "[BEGIN HEADER]";
    private static final Pattern BEGIN_HEADER_PATTERN = Pattern.compile("\\s*(--)?\\s*(" + Pattern.quote("[BEGIN HEADER]") + ")\\s*");
    private static final Pattern END_HEADER_PATTERN = Pattern.compile("\\s*(--)?\\s*(" + Pattern.quote("[END HEADER]") + ")\\s*");
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\s*(--)?\\s*(VERSION ([0-9]+))\\s*");
    private static final Pattern HEADER_PATTERN = Pattern.compile("\\s*(--)?\\s*(.*)");
    private static final Pattern SYS_RT_TABLE_PLACEMENT_PATTERN = Pattern.compile("UPSERT\\s+\"?_SYS_RT\"?\\.\"?TABLE_PLACEMENT\"?");
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private DatabaseSqlUser sqlUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private File parameterFile = null;

    protected ProcessDatabaseReorgParameterFile() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        FileParameter fileParameter = (FileParameter)parameters.get(CmdClazzParameterName.DATABASE_REORG_PARAMETER_FILE);
        this.parameterFile = fileParameter.getFile();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() {
        block31: {
            block30: {
                if (null == this.connection) {
                    this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
                }
                volumeList = DatabaseVolumeFactory.getInstance(this.connection, this.systemUser);
                liveCacheHostName = null;
                for (DatabaseVolume volume : volumeList) {
                    if (!volume.getIsLiveCacheStore()) continue;
                    liveCacheHostName = this.database.getPublicNameForHost(this.connection, this.systemUser, volume.getHostname().get());
                    break;
                }
                this.connection.setConnectUser(this.systemUser);
                conn = this.connection.getConnection();
                sysTablePlacement = new DatabaseView("SYS", "TABLE_PLACEMENT");
                sysTablePlacementExists = sysTablePlacement.exists(conn);
                schemaVersionStatement = null;
                schemaVersionResultSet = null;
                schemaVersionStatement = conn.prepareStatement("SELECT * FROM \"_SYS_REPO\".\"SCHEMAVERSION\" WHERE \"SCHEMA_TYPE\"='rt'");
                schemaVersionResultSet = schemaVersionStatement.executeQuery();
                if (!schemaVersionResultSet.next()) ** GOTO lbl40
                LogFactory.writeLogEntry(this.getClass(), "Found _SYS_REPO.SCHEMAVERSION.");
                isConsistent = schemaVersionResultSet.getInt("IS_CONSISTENT");
                if (isConsistent == 0) {
                    LogFactory.writeLogEntry(this.getClass(), "IS_CONSISTENT: " + isConsistent);
                    throw new HdbException("The SAP HANA runtime schema is not consistent. Please check your database configuration.");
                }
                dbSchemaRelease = schemaVersionResultSet.getString("DB_SCHEMA_RELEASE");
                if (!"1.00".equals(dbSchemaRelease)) {
                    LogFactory.writeLogEntry(this.getClass(), "DB_SCHEMA_RELEASE: " + dbSchemaRelease);
                    throw new HdbException("The SAP HANA release " + dbSchemaRelease + " is not supported by this installer.");
                }
                dbSchemaVersion = schemaVersionResultSet.getInt("DB_SCHEMA_VERSION");
                if (dbSchemaVersion >= 21) break block30;
                LogFactory.writeLogEntry(this.getClass(), "The DB schema version is " + dbSchemaVersion + ". No processing of the parameter file is necessary.");
                this.resultFileWriter.append(this.parameterFile.getAbsolutePath());
                IOUtils.closeQuietly(schemaVersionResultSet);
                IOUtils.closeQuietly(schemaVersionStatement);
                IOUtils.closeQuietly(conn);
                return;
            }
            break block31;
lbl40:
            // 1 sources

            if (sysTablePlacementExists) {
                LogFactory.writeLogEntry(this.getClass(), "Found view " + sysTablePlacement.getFullName() + ".");
                dbSchemaVersion = 40;
                break block31;
            }
            sysRtTablePlacement = new DatabaseTable("_SYS_RT", "TABLE_PLACEMENT");
            LogFactory.writeLogEntry(this.getClass(), "No result was returned when querying for the schema version. Checking " + sysRtTablePlacement.getFullName());
            dbSchemaVersion = this.checkDatabaseObjects(conn, new DatabaseCatalogObject[]{sysRtTablePlacement});
            if (dbSchemaVersion != -1) break block31;
            this.resultFileWriter.append(this.parameterFile.getAbsolutePath());
            IOUtils.closeQuietly(schemaVersionResultSet);
            IOUtils.closeQuietly(schemaVersionStatement);
            IOUtils.closeQuietly(conn);
            return;
        }
        IOUtils.closeQuietly(schemaVersionResultSet);
        IOUtils.closeQuietly(schemaVersionStatement);
        IOUtils.closeQuietly(conn);
        br = null;
        bw = null;
        try {
            temp = File.createTempFile(this.parameterFile.getName(), ".txt");
            br = new BufferedReader(new FileReader(this.parameterFile));
            bw = new BufferedWriter(new FileWriter(temp));
            header = false;
            endHeader = false;
            while ((line = br.readLine()) != null) {
                block32: {
                    block33: {
                        if (!header) break block33;
                        versionMatcher = ProcessDatabaseReorgParameterFile.VERSION_PATTERN.matcher(line);
                        endHeaderMatcher = ProcessDatabaseReorgParameterFile.END_HEADER_PATTERN.matcher(line);
                        headerMatcher = ProcessDatabaseReorgParameterFile.HEADER_PATTERN.matcher(line);
                        if (versionMatcher.matches()) {
                            try {
                                version = Integer.parseInt(versionMatcher.group(3));
                                LogFactory.writeLogEntry(this.getClass(), "Reorg parameter version " + version);
                            }
                            catch (NumberFormatException e) {
                                LogFactory.writeLogEntry(this.getClass(), "Invalid version line: " + line + ". Expected 'VERSION [0-9]+'. Error message: " + e.getMessage());
                            }
                            line = " * " + versionMatcher.group(2);
                            break block32;
                        } else if (endHeaderMatcher.matches()) {
                            header = false;
                            endHeader = true;
                            line = " * " + endHeaderMatcher.group(2);
                            break block32;
                        } else {
                            line = headerMatcher.matches() ? " * " + headerMatcher.group(2) : " * " + line;
                        }
                        break block32;
                    }
                    beginHeaderMatcher = ProcessDatabaseReorgParameterFile.BEGIN_HEADER_PATTERN.matcher(line);
                    if (beginHeaderMatcher.matches()) {
                        header = true;
                        bw.write("/*");
                        bw.newLine();
                        line = " * " + beginHeaderMatcher.group(2);
                    } else {
                        if ((line = line.replaceAll(Pattern.quote("$$PLACEHOLDER"), this.sqlUser.getName().get())).contains("$$LIVECACHE_PLACEHOLDER")) {
                            if (liveCacheHostName == null) {
                                throw new HdbException("A SAP HANA liveCache placeholder was found in the table placement configuration file, but the given SAP HANA database doesn't contain a SAP HANA liveCache node. Please check your database configuration.");
                            }
                            line = line.replaceAll(Pattern.quote("$$LIVECACHE_PLACEHOLDER"), liveCacheHostName);
                        }
                        if (sysTablePlacementExists) {
                            sysRtTablePlacementMatcher = ProcessDatabaseReorgParameterFile.SYS_RT_TABLE_PLACEMENT_PATTERN.matcher(line);
                            if (sysRtTablePlacementMatcher.find()) {
                                throw new HdbException("The table placement file uses an old format ('UPSERT _SYS_RT.TABLE_PLACEMENT' instead of 'ALTER SYSTEM ALTER TABLE PLACEMENT'). Please download the most recent version from the SAP note.");
                            }
                        } else {
                            line = dbSchemaVersion >= 21 && dbSchemaVersion < 24 ? line.replaceAll(Pattern.quote("INITIAL_PARTITIONS"), "INITAL_PARTITIONS") : line.replaceAll(Pattern.quote("INITAL_PARTITIONS"), "INITIAL_PARTITIONS");
                        }
                    }
                }
                bw.write(line);
                bw.newLine();
                if (!endHeader) continue;
                bw.write(" */");
                bw.newLine();
                endHeader = false;
            }
            br.close();
            bw.flush();
            bw.close();
            if (header) {
                throw new HdbException("No '[END HEADER]' was found in the parameter file. Please remove '[BEGIN HEADER]' or add '[END HEADER]'.");
            }
            this.resultFileWriter.append(temp.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            try {
                throw new HdbException(e);
                catch (IOException e) {
                    throw new HdbException(e);
                }
            }
            catch (Throwable var19_26) {
                IOUtils.closeQuietly(bw);
                IOUtils.closeQuietly(br);
                throw var19_26;
            }
        }
        catch (SQLException e) {
            try {
                throw new HdbException(e);
            }
            catch (Throwable var11_14) {
                IOUtils.closeQuietly(schemaVersionResultSet);
                IOUtils.closeQuietly(schemaVersionStatement);
                IOUtils.closeQuietly(conn);
                throw var11_14;
            }
        }
        IOUtils.closeQuietly(bw);
        IOUtils.closeQuietly(br);
    }

    private int checkDatabaseObjects(Connection conn, DatabaseCatalogObject ... objects) throws SQLException {
        int dbSchemaVersion = -1;
        for (DatabaseCatalogObject object : objects) {
            dbSchemaVersion = this.checkDatabaseObject(conn, object);
            if (dbSchemaVersion == -1) continue;
            return dbSchemaVersion;
        }
        return dbSchemaVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkDatabaseObject(Connection conn, DatabaseCatalogObject object) throws SQLException {
        ResultSet tablePlacementResultSet;
        PreparedStatement tablePlacementStatement;
        ResultSet tableExistsResultSet;
        PreparedStatement tableExistsStatement;
        int dbSchemaVersion;
        block7: {
            int n;
            dbSchemaVersion = -1;
            tableExistsStatement = null;
            tableExistsResultSet = null;
            tablePlacementStatement = null;
            tablePlacementResultSet = null;
            try {
                if (object.exists(conn)) {
                    LogFactory.writeLogEntry(this.getClass(), "Found " + object.getType().name().toLowerCase(Locale.ENGLISH) + " '" + object.getFullName() + "'.");
                    tablePlacementStatement = conn.prepareStatement("SELECT * FROM " + object.getFullNameQuoted() + "");
                    tablePlacementResultSet = tablePlacementStatement.executeQuery();
                    ResultSetMetaData tablePlacementMetaData = tablePlacementResultSet.getMetaData();
                    boolean initalPartitionsFound = false;
                    boolean initialPartitionsFound = false;
                    for (int i = 0; i < tablePlacementMetaData.getColumnCount(); ++i) {
                        String columnName = tablePlacementMetaData.getColumnName(i);
                        if (INITAL_PARTITIONS_NO_I.equals(columnName)) {
                            initalPartitionsFound = true;
                            continue;
                        }
                        if (!INITIAL_PARTITIONS.equals(columnName)) continue;
                        initialPartitionsFound = true;
                    }
                    if (initalPartitionsFound) {
                        dbSchemaVersion = 23;
                        break block7;
                    }
                    if (initialPartitionsFound) {
                        dbSchemaVersion = 25;
                        break block7;
                    }
                    throw new HdbException("Neither column 'INITAL_PARTITIONS' nor column 'INITIAL_PARTITIONS' was found in " + object.getType().name().toLowerCase(Locale.ENGLISH) + " " + object.getFullName() + ".");
                }
                LogFactory.writeLogEntry(this.getClass(), object.getType().name().toLowerCase(Locale.ENGLISH) + " '" + object.getFullName() + "' not found.");
                n = -1;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(tableExistsResultSet);
                IOUtils.closeQuietly(tablePlacementResultSet);
                IOUtils.closeQuietly(tableExistsStatement);
                IOUtils.closeQuietly(tablePlacementStatement);
                throw throwable;
            }
            IOUtils.closeQuietly(tableExistsResultSet);
            IOUtils.closeQuietly(tablePlacementResultSet);
            IOUtils.closeQuietly(tableExistsStatement);
            IOUtils.closeQuietly(tablePlacementStatement);
            return n;
        }
        IOUtils.closeQuietly(tableExistsResultSet);
        IOUtils.closeQuietly(tablePlacementResultSet);
        IOUtils.closeQuietly(tableExistsStatement);
        IOUtils.closeQuietly(tablePlacementStatement);
        return dbSchemaVersion;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

