/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.CallableStatement;
import java.sql.SQLException;

public class RebuildRemoteDependency
implements CmdClazz {
    private Database database;
    private DatabaseSystemUser systemUser;
    private JdbcDriver jdbcDriver;
    private JdbcConnection connection;
    private ResultFileWriter resultFileWriter;

    protected RebuildRemoteDependency() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
            this.connection.setConnectUser(this.systemUser);
        }
        this.callCheckCatalog();
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }

    private void callCheckCatalog() {
        String sql = "CALL CHECK_CATALOG ('REBUILD_REMOTE_DEPENDENCY', null, null, null)";
        try {
            CallableStatement cs = this.connection.getConnection().prepareCall("{" + sql + "}");
            LogFactory.writeLogEntry(this.getClass(), "Executing " + sql);
            cs.execute();
            this.resultFileWriter.append("true");
        }
        catch (SQLException e) {
            throw new HdbException(e);
        }
    }
}

