/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabasePort;
import com.sap.hdb.sl.lib.instance.DatabaseTenant;
import com.sap.hdb.sl.lib.instance.Hostname;
import com.sap.hdb.sl.lib.instance.Instance;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.mem.HdbsllibMem;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseUserAdmin;
import com.sap.hdb.sl.lib.user.SystemDatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.password.DatabaseSqlUserPassword;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.ArrayList;
import java.util.List;

public class RecreateDatabaseTenant
implements CmdClazz {
    private DatabaseSqlUserPassword tenantPassword = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private ResultFileWriter resultFileWriter;
    private Sid tenantSid = null;
    private Database systemDatabase = null;
    private DatabaseSystemUser systemDatabaseUser = null;
    private String dbIsolationLevel = "low";
    private String tenantOsUser = "";
    private String tenantOsGroup = "";
    private static String MASTER_HOSTNAME = "[Tenant_Master_Hostname]";
    private static String PORT_NUMBER = "[Tenant_Port_Number]";
    private static String SLAVE_HOSTNAMES = "[Tenant_Slave_Hostname]";

    protected RecreateDatabaseTenant() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.tenantPassword = PasswordFactory.getDatabaseSqlUserPassword(parameters.get(CmdClazzParameterName.DATABASE_SYSTEM_USER_PASSWORD).getValue());
        this.jdbcDriver = new JdbcDriver(parameters);
        this.tenantSid = new Sid(parameters.get(CmdClazzParameterName.DATABASE_SID).getValue());
        this.systemDatabaseUser = SystemDatabaseSystemUserFactory.getUser(parameters);
        this.systemDatabase = InstanceFactory.getDatabaseInstance(parameters);
        this.systemDatabase.setSid(new Sid("SYSTEMDB"));
        if (parameters.containsKey(CmdClazzParameterName.DB_ISOLATION_LEVEL)) {
            this.dbIsolationLevel = parameters.get(CmdClazzParameterName.DB_ISOLATION_LEVEL).getValue();
            if (this.dbIsolationLevel.equalsIgnoreCase("high")) {
                if (parameters.containsKey(CmdClazzParameterName.TENANT_OS_USER) && parameters.containsKey(CmdClazzParameterName.TENANT_OS_GROUP)) {
                    this.tenantOsUser = parameters.get(CmdClazzParameterName.TENANT_OS_USER).getValue();
                    this.tenantOsGroup = parameters.get(CmdClazzParameterName.TENANT_OS_GROUP).getValue();
                } else {
                    this.resultFileWriter.append("false");
                    String errorText = "RECREATE_DATABASE_TENANT was started with parameter DB_ISOLATION_LEVEL=high.\nSpecify also TENANT_OS_USER and TENANT_OS_GROUP for the tenant creation.";
                    this.resultFileWriter.append(errorText);
                    throw new HdbException(errorText);
                }
            }
        }
    }

    @Override
    public void execute() {
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.systemDatabase);
        if (this.tenantSid.get().isEmpty()) {
            String errorText = "Database SID must not be empty!";
            this.resultFileWriter.append("false");
            this.resultFileWriter.append(errorText);
            throw new HdbException(errorText);
        }
        DatabaseTenant databaseTenant = InstanceFactory.getDatabaseTenant(this.tenantSid, this.connection);
        if (this.dbIsolationLevel.equalsIgnoreCase("high")) {
            databaseTenant.setIsolationLevelHigh(this.tenantOsUser, this.tenantOsGroup);
        }
        boolean tenantExists = false;
        Hostname masterHost = null;
        DatabasePort port = null;
        List<Hostname> slaveNodes = null;
        try {
            tenantExists = databaseTenant.exists(this.connection, this.systemDatabaseUser);
            if (tenantExists) {
                LogFactory.writeLogEntry(this.getClass(), "Tenant database found. Save information before recreate.");
                masterHost = databaseTenant.getMasterHost(this.connection, this.systemDatabaseUser);
                port = databaseTenant.getPortWithSystemDB(this.connection, this.systemDatabaseUser);
                slaveNodes = databaseTenant.getSlaveHosts(this.connection, this.systemDatabaseUser);
                this.saveTenantInfo(masterHost, port, slaveNodes);
                databaseTenant.stop(this.connection, this.systemDatabaseUser);
                databaseTenant.drop(this.connection, this.systemDatabaseUser);
            } else {
                LogFactory.writeLogEntry(this.getClass(), "Tenant database does not exist. Checking HdbsllibMem...");
                masterHost = this.getMasterHostnameFromMem();
                port = this.getPortNumberFromMem();
                slaveNodes = this.getSlaveHostanamesFromMem();
            }
            if (masterHost == null) {
                masterHost = new Hostname(this.systemDatabase.getMasterHost(this.connection, this.systemDatabaseUser));
            }
            this.createTenant(databaseTenant, this.connection, this.tenantPassword, this.systemDatabaseUser, masterHost, port, slaveNodes);
            if (this.connection.getDatabase().isEncryptTrue() && this.connection.supportsClientPKI()) {
                databaseTenant.waitForPKI(this.connection, this.systemDatabaseUser);
            }
            this.deleteTenantInfo();
            DatabaseUserAdmin admin = DatabaseUserAdmin.getInstance();
            if (admin != null) {
                admin.resetInitialState();
            }
        }
        catch (HdbException e) {
            this.resultFileWriter.append("false");
            if (e.testLicenseExpired()) {
                this.resultFileWriter.append(HdbException.LICENSE_EXPIRED);
            }
            LogFactory.writeLogEntry(this.getClass(), "Recreate Database Tenant ended with error: " + e.getMessage());
            throw e;
        }
        this.resultFileWriter.append("true");
    }

    private void createTenant(DatabaseTenant databaseTenant, JdbcConnection connection, DatabaseSqlUserPassword tenantSystemUserPassword, DatabaseSystemUser systemDatabaseUser, Hostname hostName, DatabasePort port, List<Hostname> slaveNodes) {
        if (port == null) {
            databaseTenant.create(this.connection, this.tenantPassword, this.systemDatabaseUser, hostName);
        } else {
            databaseTenant.create(this.connection, this.tenantPassword, this.systemDatabaseUser, hostName, port);
            for (Hostname slaveNode : slaveNodes) {
                databaseTenant.addService(Instance.ServiceName.INDEXSERVER, slaveNode, port, this.connection, this.systemDatabaseUser);
            }
        }
    }

    private void saveTenantInfo(Hostname masterHost, DatabasePort port, List<Hostname> slaveNodes) {
        String slave_host_list = new String("");
        HdbsllibMem mem = HdbsllibMem.getInstance();
        mem.save(MASTER_HOSTNAME, masterHost.toString());
        mem.save(PORT_NUMBER, port.getAsInteger().toString());
        if (slaveNodes != null && !slaveNodes.isEmpty()) {
            for (Hostname slaveNode : slaveNodes) {
                slave_host_list = slave_host_list + "," + slaveNode.toString();
            }
            mem.save(SLAVE_HOSTNAMES, slave_host_list.substring(1));
        }
    }

    private void deleteTenantInfo() {
        HdbsllibMem mem = HdbsllibMem.getInstance();
        mem.delete(MASTER_HOSTNAME);
        mem.delete(PORT_NUMBER);
        mem.delete(SLAVE_HOSTNAMES);
    }

    private Hostname getMasterHostnameFromMem() {
        HdbsllibMem mem = HdbsllibMem.getInstance();
        String host = mem.read(MASTER_HOSTNAME);
        Hostname hostname = null;
        if (host != null) {
            hostname = new Hostname(host);
        }
        return hostname;
    }

    private DatabasePort getPortNumberFromMem() {
        HdbsllibMem mem = HdbsllibMem.getInstance();
        String port = mem.read(PORT_NUMBER);
        DatabasePort portNumber = null;
        if (port != null) {
            portNumber = new DatabasePort(port);
        }
        return portNumber;
    }

    private List<Hostname> getSlaveHostanamesFromMem() {
        HdbsllibMem mem = HdbsllibMem.getInstance();
        String slave_host_list = mem.read(SLAVE_HOSTNAMES);
        ArrayList<Hostname> slaveHostnames = new ArrayList<Hostname>();
        if (slave_host_list != null) {
            String[] list = slave_host_list.split(",");
            for (int i = 0; i < list.length; ++i) {
                slaveHostnames.add(new Hostname(list[i]));
            }
        }
        return slaveHostnames;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

