/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.CallableStatement;
import java.util.List;

public class RemoveLegacyCalculationScenarios
implements CmdClazz {
    private ResultFileWriter resultFileWriter;
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;

    protected RemoveLegacyCalculationScenarios() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        this.connection.setConnectUser(this.systemUser);
        if (this.clearProcedureExists() && this.clearProcedureExecutionIsSafe()) {
            this.executeClearProcedure();
        }
    }

    private void executeClearProcedure() {
        try {
            LogFactory.writeLogEntry(this.getClass(), "Run SQL command: CALL SYS.SQLSCRIPT_CLEAR_LEGACY_CALCSCENARIOS_DEV()");
            CallableStatement cs = this.connection.getConnection().prepareCall("{CALL SYS.SQLSCRIPT_CLEAR_LEGACY_CALCSCENARIOS_DEV()}");
            cs.execute();
        }
        catch (Exception e) {
            LogFactory.writeLogEntry(this.getClass(), "Could not execute SYS.SQLSCRIPT_CLEAR_LEGACY_CALCSCENARIOS_DEV()");
        }
    }

    private boolean clearProcedureExecutionIsSafe() {
        boolean safe = false;
        try {
            List<String> result = this.connection.executeSQLCommand("SELECT SCENARIO_NAME FROM m_ce_calcscenarios WHERE JSON LIKE '%_SYS_SS_CE_%' AND IS_PERSISTENT = 'TRUE' AND COMPONENT <> 'STORED PROCEDURE'");
            if (result.size() == 0) {
                safe = true;
            }
        }
        catch (Exception e) {
            LogFactory.writeLogEntry(this.getClass(), "Could not decide if it is safe to execute CLEAR built-in procedure - SYS.SQLSCRIPT_CLEAR_LEGACY_CALCSCENARIOS_DEV.Will not execute it, because it could invalidate user calculation indexes");
        }
        return safe;
    }

    private boolean clearProcedureExists() {
        boolean exist = false;
        List<String> result = this.connection.executeSQLCommand("SELECT OBJECT_OID FROM OBJECTS WHERE OBJECT_NAME = 'SQLSCRIPT_CLEAR_LEGACY_CALCSCENARIOS_DEV' AND OBJECT_TYPE = 'PROCEDURE'");
        if (result.size() > 0) {
            exist = true;
        }
        return exist;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

