/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseTenant;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.instance.TenantSid;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.SystemDatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class RenameTenantDatabase
implements CmdClazz {
    private Sid tenantSid;
    private Sid tenantSidNew;
    private DatabaseSystemUser systemDatabaseUser;
    private Database systemDatabase;
    private JdbcDriver jdbcDriver;
    private ResultFileWriter resultWriter;

    protected RenameTenantDatabase() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.tenantSid = new TenantSid(parameters.get(CmdClazzParameterName.DATABASE_SID).getValue());
        this.tenantSidNew = new TenantSid(parameters.get(CmdClazzParameterName.DATABASE_SID_NEW).getValue());
        this.systemDatabaseUser = SystemDatabaseSystemUserFactory.getUser(parameters);
        this.systemDatabase = InstanceFactory.getSystemDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        LogFactory.writeLogEntry(this.getClass(), "Stopping HANA tenant " + this.tenantSid);
        JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.systemDatabase);
        DatabaseTenant tenant = InstanceFactory.getDatabaseTenant(this.tenantSid, connection);
        DatabaseTenant tenantNew = InstanceFactory.getDatabaseTenant(this.tenantSidNew, connection);
        tenant.stop(connection, this.systemDatabaseUser);
        LogFactory.writeLogEntry(this.getClass(), "Starting rename of HANA tenant  " + this.tenantSid + " to " + this.tenantSidNew);
        tenant.rename(connection, this.systemDatabaseUser, this.tenantSidNew);
        LogFactory.writeLogEntry(this.getClass(), "Starting HANA tenant " + this.tenantSidNew);
        tenantNew.start(connection, this.systemDatabaseUser);
        LogFactory.writeLogEntry(this.getClass(), "Database rename was successful.");
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }
}

